/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.LogicalArea;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.model.RDFResource;
import org.eclipse.rdf4j.model.IRI;

public class ModelTransformer {
    private IRIFactory iriFactory;

    public ModelTransformer(IRIFactory iriFactory) {
        this.iriFactory = iriFactory;
    }

    public IRIFactory getIriFactory() {
        return this.iriFactory;
    }

    public void setIriFactory(IRIFactory iriFactory) {
        this.iriFactory = iriFactory;
    }

    protected IRI getBoxIri(IRI pageIri, Box box) {
        IRI curIri = this.getCurrentIri(box);
        if (curIri != null) {
            return curIri;
        }
        return this.getIriFactory().createBoxURI(pageIri, box);
    }

    protected IRI getAreaIri(IRI areaTreeIri, Area area) {
        IRI curIri = this.getCurrentIri(area);
        if (curIri != null) {
            return curIri;
        }
        return this.getIriFactory().createAreaURI(areaTreeIri, area);
    }

    protected IRI getLogicalAreaIri(IRI areaTreeIri, LogicalArea area, int ord) {
        IRI curIri = this.getCurrentIri(area);
        if (curIri != null) {
            return curIri;
        }
        return this.getIriFactory().createLogicalAreaURI(areaTreeIri, ord);
    }

    protected IRI getTextChunkIri(IRI chunkSetIri, TextChunk chunk) {
        IRI curIri = this.getCurrentIri(chunk);
        if (curIri != null) {
            return curIri;
        }
        return this.getIriFactory().createTextChunkURI(chunkSetIri, chunk);
    }

    protected IRI getCurrentIri(Object obj) {
        if (obj instanceof RDFResource) {
            return ((RDFResource)obj).getIri();
        }
        return null;
    }
}

