/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf.model;

import cz.vutbr.fit.layout.impl.DefaultPage;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.rdf.model.RDFArtifact;
import cz.vutbr.fit.layout.rdf.model.RDFBox;
import cz.vutbr.fit.layout.rdf.model.RDFResource;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;

public class RDFPage
extends DefaultPage
implements RDFResource,
RDFArtifact {
    protected Map<IRI, RDFBox> boxIris;
    private Set<Statement> additionalStatements;

    public RDFPage(URL url) {
        super(url);
    }

    public RDFPage(Page src, IRI pageIri) {
        super(src);
        this.setIri(pageIri);
    }

    public Map<IRI, RDFBox> getBoxIris() {
        return this.boxIris;
    }

    public void setBoxIris(Map<IRI, RDFBox> boxUris) {
        this.boxIris = boxUris;
    }

    public RDFBox findBoxByIri(IRI uri) {
        if (this.boxIris != null) {
            return this.boxIris.get(uri);
        }
        return null;
    }

    public void setAdditionalStatements(Set<Statement> additionalStatements) {
        this.additionalStatements = additionalStatements;
    }

    @Override
    public Set<Statement> getAdditionalStatements() {
        return this.additionalStatements;
    }

    @Override
    public void recompute() {
        if (this.getRoot() != null) {
            this.recursiveInvalidateStyle(this.getRoot());
        }
    }

    private void recursiveInvalidateStyle(Box root) {
        root.childrenChanged();
        for (Box child : root.getChildren()) {
            this.recursiveInvalidateStyle(child);
        }
    }
}

