/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.ChunkSet;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelBuilder;
import cz.vutbr.fit.layout.rdf.ModelBuilderBase;
import cz.vutbr.fit.layout.rdf.Serialization;
import cz.vutbr.fit.layout.rdf.model.RDFChunkSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;

public class ChunkSetModelBuilder
extends ModelBuilderBase
implements ModelBuilder {
    private ValueFactory vf = SimpleValueFactory.getInstance();
    private int next_order;

    public ChunkSetModelBuilder(IRIFactory iriFactory) {
        super(iriFactory);
    }

    @Override
    public Model createGraph(Artifact artifact) {
        return this.createModel((ChunkSet)artifact, artifact.getIri());
    }

    private Model createModel(ChunkSet cset, IRI csetIri) {
        Set<Statement> toadd;
        LinkedHashModel graph = new LinkedHashModel();
        IRI areaTreeNode = cset.getAreaTreeIri();
        this.addArtifactData((Model)graph, (Artifact)cset);
        graph.add((Resource)csetIri, SEGM.hasAreaTree, (Value)areaTreeNode, new Resource[0]);
        if (cset.getPageIri() != null) {
            graph.add((Resource)csetIri, SEGM.hasSourcePage, (Value)cset.getPageIri(), new Resource[0]);
        }
        this.next_order = 0;
        for (TextChunk chunk : cset.getTextChunks()) {
            this.addChunk(chunk, csetIri, (Model)graph);
        }
        if (cset instanceof RDFChunkSet && (toadd = ((RDFChunkSet)cset).getAdditionalStatements()) != null) {
            graph.addAll(toadd);
        }
        return graph;
    }

    private void addChunk(TextChunk chunk, IRI csetIri, Model graph) {
        IRI ciri = this.getTextChunkIri(csetIri, chunk);
        graph.add((Resource)ciri, RDF.TYPE, (Value)SEGM.TextChunk, new Resource[0]);
        if (chunk.getName() != null) {
            graph.add((Resource)ciri, RDFS.LABEL, (Value)this.vf.createLiteral(chunk.getName()), new Resource[0]);
        }
        graph.add((Resource)ciri, BOX.documentOrder, (Value)this.vf.createLiteral(this.next_order++), new Resource[0]);
        graph.add((Resource)ciri, SEGM.belongsToChunkSet, (Value)csetIri, new Resource[0]);
        graph.add((Resource)ciri, SEGM.text, (Value)this.vf.createLiteral(chunk.getText()), new Resource[0]);
        if (chunk.getEffectiveBackgroundColor() != null) {
            graph.add((Resource)ciri, BOX.backgroundColor, (Value)this.vf.createLiteral(Serialization.colorString(chunk.getEffectiveBackgroundColor())), new Resource[0]);
        }
        graph.add((Resource)ciri, BOX.color, (Value)this.vf.createLiteral(Serialization.colorString(chunk.getColor())), new Resource[0]);
        graph.add((Resource)ciri, BOX.fontFamily, (Value)this.vf.createLiteral(chunk.getFontFamily()), new Resource[0]);
        this.addTextStyle(graph, ciri, (ContentRect)chunk);
        if (chunk.getSourceArea() != null) {
            IRI areaIri = this.getAreaIri(chunk.getSourceArea().getAreaTree().getIri(), chunk.getSourceArea());
            graph.add((Resource)ciri, SEGM.hasSourceArea, (Value)areaIri, new Resource[0]);
        }
        if (chunk.getSourceBox() != null) {
            IRI boxIri = this.getBoxIri(chunk.getSourceBox().getPageIri(), chunk.getSourceBox());
            graph.add((Resource)ciri, SEGM.hasSourceBox, (Value)boxIri, new Resource[0]);
        }
        this.insertBounds(ciri, BOX.bounds, "b", chunk.getBounds(), graph);
        if (chunk.getTags().size() > 0) {
            Map tags = chunk.getTags();
            for (Tag t : tags.keySet()) {
                Float support = (Float)tags.get(t);
                if (support == null || !(support.floatValue() > 0.0f)) continue;
                IRI tagUri = t.getIri();
                graph.add((Resource)ciri, SEGM.hasTag, (Value)tagUri, new Resource[0]);
                IRI supUri = this.getIriFactory().createTagSupportURI(ciri, t);
                graph.add((Resource)ciri, SEGM.tagSupport, (Value)supUri, new Resource[0]);
                graph.add((Resource)supUri, SEGM.support, (Value)this.vf.createLiteral(support.floatValue()), new Resource[0]);
                graph.add((Resource)supUri, SEGM.hasTag, (Value)tagUri, new Resource[0]);
            }
        }
    }
}

