/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.api.ArtifactInfo;
import cz.vutbr.fit.layout.impl.BaseArtifact;
import cz.vutbr.fit.layout.ontology.FL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.query.BindingSet;

public class RDFArtifactInfo
extends ArtifactInfo {
    private Set<Statement> additionalStatements;

    public RDFArtifactInfo(Model model, IRI artifactIri) {
        this(model, artifactIri, true);
    }

    public RDFArtifactInfo(Model model, IRI artifactIri, boolean useAdditionalStatements) {
        super(null);
        this.setIri(artifactIri);
        this.additionalStatements = new HashSet<Statement>();
        for (Statement st : model) {
            if (!st.getSubject().equals(artifactIri) || this.processStatement(st) || !useAdditionalStatements) continue;
            this.additionalStatements.add(st);
        }
    }

    public RDFArtifactInfo(BindingSet binding) {
        super(null);
        this.additionalStatements = new HashSet<Statement>();
        this.setIri((IRI)binding.getBinding("pg").getValue());
        this.setArtifactType((IRI)binding.getBinding("type").getValue());
        this.setLabel(binding.getBinding("label").getValue().stringValue());
        this.setCreator(binding.getBinding("creator").getValue().stringValue());
        this.setCreatorParams(binding.getBinding("creatorParams").getValue().stringValue());
        if (binding.hasBinding("createdOn")) {
            this.setCreatedOn(((Literal)binding.getBinding("createdOn").getValue()).calendarValue().toGregorianCalendar().getTime());
        }
        if (binding.hasBinding("parent")) {
            this.setParentIri((IRI)binding.getBinding("parent").getValue());
        }
    }

    public Set<Statement> getAdditionalStatements() {
        return this.additionalStatements;
    }

    protected boolean processStatement(Statement st) {
        boolean ret = true;
        if (st.getPredicate().equals((Object)RDF.TYPE)) {
            Value val = st.getObject();
            if (val instanceof IRI) {
                this.setArtifactType((IRI)val);
            }
        } else if (st.getPredicate().equals((Object)RDFS.LABEL)) {
            this.setLabel(st.getObject().stringValue());
        } else if (st.getPredicate().equals((Object)FL.createdOn)) {
            Value val = st.getObject();
            if (val instanceof Literal) {
                this.setCreatedOn(((Literal)val).calendarValue().toGregorianCalendar().getTime());
            }
        } else if (st.getPredicate().equals((Object)FL.hasParentArtifact)) {
            Value val = st.getObject();
            if (val instanceof IRI) {
                this.setParentIri((IRI)val);
            }
        } else if (st.getPredicate().equals((Object)FL.creator)) {
            this.setCreator(st.getObject().stringValue());
        } else if (st.getPredicate().equals((Object)FL.creatorParams)) {
            this.setCreatorParams(st.getObject().stringValue());
        } else {
            ret = false;
        }
        return ret;
    }

    public void applyToArtifact(BaseArtifact a) {
        a.setIri(this.getIri());
        a.setParentIri(this.getParentIri());
        a.setLabel(this.getLabel());
        a.setCreatedOn(this.getCreatedOn());
        a.setCreator(this.getCreator());
        a.setCreatorParams(this.getCreatorParams());
    }
}

