/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.api.ServiceConfig;
import cz.vutbr.fit.layout.ontology.FL;
import cz.vutbr.fit.layout.rdf.SparqlQueryResult;
import cz.vutbr.fit.layout.rdf.StorageException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.resultio.text.csv.SPARQLResultsCSVWriter;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.http.HTTPRepository;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.util.Repositories;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.nativerdf.NativeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFStorage
implements Closeable {
    private static Logger log = LoggerFactory.getLogger(RDFStorage.class);
    private static final String IMPORT_BASE_URI = "http://fitlayout.github.io/ontology/render.owl#";
    private Repository repo;

    protected RDFStorage(Repository repo) {
        this.repo = repo;
    }

    public static RDFStorage create(Repository repo) {
        return new RDFStorage(repo);
    }

    public static RDFStorage createMemory(String dataDir) {
        log.info("Using memory storage in {}", (Object)dataDir);
        SailRepository repo = dataDir != null ? new SailRepository((Sail)new MemoryStore(new File(dataDir))) : new SailRepository((Sail)new MemoryStore());
        return new RDFStorage((Repository)repo);
    }

    public static RDFStorage createNative(String dataDir) {
        log.info("Using native storage in {}", (Object)dataDir);
        SailRepository repo = new SailRepository((Sail)new NativeStore(new File(dataDir)));
        return new RDFStorage((Repository)repo);
    }

    public static RDFStorage createHTTP(String serverUrl, String repositoryId) {
        log.info("Using HTTP storage in {} : {}", (Object)serverUrl, (Object)repositoryId);
        HTTPRepository repo = new HTTPRepository(serverUrl, repositoryId);
        return new RDFStorage((Repository)repo);
    }

    public Repository getRepository() {
        return this.repo;
    }

    public ValueFactory getValueFactory() {
        return this.repo.getValueFactory();
    }

    public RepositoryConnection getConnection() {
        return this.repo.getConnection();
    }

    @Override
    public void close() {
        this.repo.shutDown();
    }

    public Collection<Resource> getResourcesOfType(IRI type) {
        HashSet<Resource> ret = new HashSet<Resource>();
        try (RepositoryConnection con = this.repo.getConnection();
             RepositoryResult result = con.getStatements(null, RDF.TYPE, (Value)type, new Resource[0]);){
            for (Statement st : result) {
                ret.add(st.getSubject());
            }
        }
        return ret;
    }

    public Collection<Resource> getResourcesOfType(IRI type, Resource context) {
        HashSet<Resource> ret = new HashSet<Resource>();
        try (RepositoryConnection con = this.repo.getConnection();
             RepositoryResult result = con.getStatements(null, RDF.TYPE, (Value)type, new Resource[]{context});){
            for (Statement st : result) {
                ret.add(st.getSubject());
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getPropertyValue(Resource subject, IRI predicate) throws StorageException {
        Value ret = null;
        try (RepositoryConnection con = this.repo.getConnection();
             RepositoryResult result = con.getStatements(subject, predicate, null, true, new Resource[0]);){
            if (result.hasNext()) {
                ret = ((Statement)result.next()).getObject();
            }
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        return ret;
    }

    public Model getSubjectModel(Resource subject) throws StorageException {
        Model model;
        block8: {
            RepositoryConnection con = this.repo.getConnection();
            try {
                RepositoryResult result = con.getStatements(subject, null, null, true, new Resource[0]);
                model = QueryResults.asModel((CloseableIteration)result);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StorageException(e);
                }
            }
            con.close();
        }
        return model;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRI getSubjectType(Resource subject) throws StorageException {
        try (RepositoryConnection con = this.repo.getConnection();){
            RepositoryResult result = con.getStatements(subject, RDF.TYPE, null, true, new Resource[0]);
            for (Statement st : result) {
                if (!(st.getObject() instanceof IRI)) continue;
                IRI iRI = (IRI)st.getObject();
                return iRI;
            }
            Iterator iterator = null;
            return iterator;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public Model getContextModel(Resource context) throws StorageException {
        Model model;
        block8: {
            RepositoryConnection con = this.repo.getConnection();
            try {
                RepositoryResult result = con.getStatements(null, null, null, new Resource[]{context});
                model = QueryResults.asModel((CloseableIteration)result);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StorageException(e);
                }
            }
            con.close();
        }
        return model;
    }

    public Model getContextModel(Collection<Resource> contexts) throws StorageException {
        Model model;
        block8: {
            RepositoryConnection con = this.repo.getConnection();
            try {
                Resource[] res = contexts.toArray(new Resource[contexts.size()]);
                RepositoryResult result = con.getStatements(null, null, null, res);
                model = QueryResults.asModel((CloseableIteration)result);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StorageException(e);
                }
            }
            con.close();
        }
        return model;
    }

    public Model executeSafeQuery(String query) throws StorageException {
        return this.executeSafeQuery(query, (IsolationLevel)IsolationLevels.SNAPSHOT_READ);
    }

    public Model executeSafeQuery(String query, IsolationLevel isolationLevel) throws StorageException {
        Iterator iterator;
        block11: {
            RepositoryConnection con = this.repo.getConnection();
            try {
                if (isolationLevel != null) {
                    con.begin(isolationLevel);
                }
                GraphQueryResult graphResult = con.prepareGraphQuery(query).evaluate();
                LinkedHashModel ret = new LinkedHashModel();
                for (Statement st : graphResult) {
                    ret.add((Object)st);
                }
                graphResult.close();
                if (isolationLevel != null) {
                    con.commit();
                }
                iterator = ret;
                if (con == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StorageException(e);
                }
            }
            con.close();
        }
        return iterator;
    }

    public List<BindingSet> executeSafeTupleQuery(String query) throws StorageException {
        try {
            return (List)Repositories.tupleQuery((Repository)this.repo, (String)query, r -> QueryResults.asList((Iteration)r));
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public List<BindingSet> executeSparqlTupleQuery(String queryString, boolean distinct, long limit, long offset) throws StorageException {
        List list;
        block9: {
            RepositoryConnection con = this.repo.getConnection();
            try {
                TupleQuery query = con.prepareTupleQuery(queryString);
                TupleQueryResult result = query.evaluate();
                if (distinct) {
                    result = QueryResults.distinctResults((TupleQueryResult)result);
                }
                result = QueryResults.limitResults((TupleQueryResult)result, (long)limit, (long)offset);
                list = QueryResults.asList((Iteration)result);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StorageException(e);
                }
            }
            con.close();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SparqlQueryResult executeSparqlQuery(String queryString, boolean distinct, long limit, long offset) throws StorageException {
        try (RepositoryConnection con = this.repo.getConnection();){
            Query query = con.prepareQuery(queryString);
            if (query instanceof TupleQuery) {
                TupleQueryResult result = ((TupleQuery)query).evaluate();
                if (distinct) {
                    result = QueryResults.distinctResults((TupleQueryResult)result);
                }
                result = QueryResults.limitResults((TupleQueryResult)result, (long)limit, (long)offset);
                SparqlQueryResult sparqlQueryResult = SparqlQueryResult.createTuple(QueryResults.asList((Iteration)result));
                return sparqlQueryResult;
            }
            if (query instanceof GraphQuery) {
                GraphQueryResult result = ((GraphQuery)query).evaluate();
                if (distinct) {
                    result = QueryResults.distinctResults((GraphQueryResult)result);
                }
                result = QueryResults.limitResults((GraphQueryResult)result, (long)limit, (long)offset);
                SparqlQueryResult sparqlQueryResult = SparqlQueryResult.createGraph(QueryResults.asList((Iteration)result));
                return sparqlQueryResult;
            }
            if (!(query instanceof BooleanQuery)) throw new StorageException("Unsupported query type" + query.getClass().getName());
            boolean result = ((BooleanQuery)query).evaluate();
            SparqlQueryResult sparqlQueryResult = SparqlQueryResult.createBoolean(result);
            return sparqlQueryResult;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void execSparqlUpdate(String query) throws StorageException {
        try (RepositoryConnection con = this.repo.getConnection();){
            Update upd = con.prepareUpdate(QueryLanguage.SPARQL, query);
            upd.execute();
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void queryExportCSV(String queryString, OutputStream ostream) throws StorageException {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.prepareTupleQuery(queryString).evaluate((TupleQueryResultHandler)new SPARQLResultsCSVWriter(ostream));
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void add(IRI subj, IRI pred, IRI obj, IRI context) {
        try (RepositoryConnection con = this.repo.getConnection();){
            try {
                con.begin();
                con.add((Resource)subj, pred, (Value)obj, new Resource[]{context});
                con.commit();
            }
            catch (RepositoryException e) {
                con.rollback();
            }
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void addValue(IRI subj, IRI pred, Object value, IRI context) {
        try (RepositoryConnection con = this.repo.getConnection();){
            ValueFactory vf = this.getValueFactory();
            Value val = this.createValueFromObject(value, vf);
            con.add((Resource)subj, pred, val, new Resource[]{context});
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void insertGraph(Model graph) throws StorageException {
        try (RepositoryConnection con = this.repo.getConnection();){
            try {
                con.begin();
                con.add((Iterable)graph, new Resource[0]);
                con.commit();
            }
            catch (RepositoryException e) {
                con.rollback();
            }
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void insertGraph(Model graph, IRI contextIri) throws StorageException {
        try (RepositoryConnection con = this.repo.getConnection();){
            try {
                con.begin();
                con.add((Iterable)graph, new Resource[]{contextIri});
                con.commit();
            }
            catch (RepositoryException e) {
                con.rollback();
            }
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void importTurtle(String query) throws StorageException, IOException {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.add((Reader)new StringReader(query), IMPORT_BASE_URI, RDFFormat.TURTLE, new Resource[0]);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void importTurtle(String query, IRI context) throws StorageException, IOException {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.add((Reader)new StringReader(query), IMPORT_BASE_URI, RDFFormat.TURTLE, new Resource[]{context});
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void importXML(String query) throws StorageException, IOException {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.add((Reader)new StringReader(query), IMPORT_BASE_URI, RDFFormat.RDFXML, new Resource[0]);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void importXML(String query, IRI context) throws StorageException, IOException {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.add((Reader)new StringReader(query), IMPORT_BASE_URI, RDFFormat.RDFXML, new Resource[]{context});
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void importStream(InputStream stream, RDFFormat dataFormat) throws StorageException {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.add(stream, IMPORT_BASE_URI, dataFormat, new Resource[0]);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void importStream(InputStream stream, RDFFormat dataFormat, String baseURI) throws StorageException {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.add(stream, baseURI, dataFormat, new Resource[0]);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void importStream(InputStream stream, RDFFormat dataFormat, IRI context) throws StorageException {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.add(stream, IMPORT_BASE_URI, dataFormat, new Resource[]{context});
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void importStream(InputStream stream, RDFFormat dataFormat, IRI context, String baseURI) throws StorageException {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.add(stream, baseURI, dataFormat, new Resource[]{context});
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void clear() throws StorageException {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.clear(new Resource[0]);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void clear(IRI context) throws StorageException {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.clear(new Resource[]{context});
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.remove(subj, pred, obj, contexts);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void remove(IRI subj, IRI pred, IRI obj, IRI context) {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.remove((Resource)subj, pred, (Value)obj, new Resource[]{context});
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void removeValue(IRI subj, IRI pred, Object value, IRI context) {
        try (RepositoryConnection con = this.repo.getConnection();){
            ValueFactory vf = this.getValueFactory();
            Value val = this.createValueFromObject(value, vf);
            con.remove((Resource)subj, pred, val, new Resource[]{context});
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public ServiceConfig loadServiceConfig(IRI iri) throws StorageException {
        Value serviceId = this.getPropertyValue((Resource)iri, FL.service);
        if (serviceId != null && serviceId instanceof Literal) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            try (RepositoryConnection con = this.repo.getConnection();
                 RepositoryResult result = con.getStatements((Resource)iri, FL.param, null, false, new Resource[0]);){
                while (result.hasNext()) {
                    Value paramNode = ((Statement)result.next()).getObject();
                    if (!(paramNode instanceof Resource)) continue;
                    String paramName = null;
                    Object paramValue = null;
                    try (RepositoryResult pstatements = con.getStatements((Resource)paramNode, null, null, new Resource[0]);){
                        for (Statement pst : pstatements) {
                            Value val;
                            if (FL.paramName.equals((Object)pst.getPredicate())) {
                                val = pst.getObject();
                                if (!(val instanceof Literal)) continue;
                                paramName = val.stringValue();
                                continue;
                            }
                            if (!FL.paramValue.equals((Object)pst.getPredicate()) || !((val = pst.getObject()) instanceof Literal)) continue;
                            paramValue = RDFStorage.getLiteralAsObject((Literal)val);
                        }
                    }
                    if (paramName == null || paramValue == null) continue;
                    params.put(paramName, paramValue);
                }
            }
            return new ServiceConfig(serviceId.stringValue(), params);
        }
        return null;
    }

    public static Object getLiteralAsObject(Literal lval) {
        IRI type = lval.getDatatype();
        if (XSD.BOOLEAN.equals((Object)type)) {
            return lval.booleanValue();
        }
        if (XSD.DOUBLE.equals((Object)type)) {
            return lval.doubleValue();
        }
        if (XSD.FLOAT.equals((Object)type)) {
            return Float.valueOf(lval.floatValue());
        }
        if (XSD.INT.equals((Object)type) || XSD.INTEGER.equals((Object)type)) {
            return lval.intValue();
        }
        return lval.stringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastSequenceValue(IRI sequenceIri) throws StorageException {
        long ret = 0L;
        try (RepositoryConnection con = this.repo.getConnection();
             RepositoryResult result = con.getStatements((Resource)sequenceIri, RDF.VALUE, null, false, new Resource[0]);){
            Value val;
            if (result.hasNext() && (val = ((Statement)result.next()).getObject()) instanceof Literal) {
                ret = ((Literal)val).longValue();
            }
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        return ret;
    }

    public long getNextSequenceValue(IRI sequenceIri) throws StorageException {
        int tries = 100;
        while (tries > 0) {
            try {
                return this.getNextSequenceValueUnsafe(sequenceIri);
            }
            catch (StorageException e) {
                if (--tries != 0) continue;
                throw e;
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getNextSequenceValueUnsafe(IRI sequenceIri) throws StorageException {
        try {
            RepositoryConnection con = this.repo.getConnection();
            try {
                con.begin((IsolationLevel)IsolationLevels.SERIALIZABLE);
                long val = 0L;
                try (RepositoryResult result = con.getStatements((Resource)sequenceIri, RDF.VALUE, null, false, new Resource[0]);){
                    if (result.hasNext()) {
                        Statement statement = (Statement)result.next();
                        Value vval = statement.getObject();
                        if (vval instanceof Literal) {
                            val = ((Literal)vval).longValue();
                        }
                        con.remove(statement, new Resource[0]);
                    }
                }
                con.add((Resource)sequenceIri, RDF.VALUE, (Value)this.getValueFactory().createLiteral(++val), new Resource[0]);
                con.commit();
                long l = val;
                return l;
            }
            catch (RepositoryException e) {
                con.rollback();
                throw new StorageException(e);
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Namespace> getNamespaces() {
        ArrayList<Namespace> ret = new ArrayList<Namespace>();
        try (RepositoryConnection con = this.repo.getConnection();
             RepositoryResult result = con.getNamespaces();){
            while (result.hasNext()) {
                ret.add((Namespace)result.next());
            }
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        return ret;
    }

    public String getNamespace(String prefix) {
        String ret = null;
        try (RepositoryConnection con = this.repo.getConnection();){
            ret = con.getNamespace(prefix);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        return ret;
    }

    public void addNamespace(String prefix, String namespace) {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.setNamespace(prefix, namespace);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void deleteNamespace(String prefix) {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.removeNamespace(prefix);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void clearNamespaces() {
        try (RepositoryConnection con = this.repo.getConnection();){
            con.clearNamespaces();
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource> getContexts() {
        ArrayList<Resource> ret = new ArrayList<Resource>();
        try (RepositoryConnection con = this.repo.getConnection();
             RepositoryResult result = con.getContextIDs();){
            while (result.hasNext()) {
                ret.add((Resource)result.next());
            }
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        return ret;
    }

    private Value createValueFromObject(Object value, ValueFactory vf) {
        Literal val = value instanceof Integer ? vf.createLiteral(((Integer)value).intValue()) : (value instanceof Long ? vf.createLiteral(((Long)value).longValue()) : (value instanceof Float ? vf.createLiteral(((Float)value).floatValue()) : (value instanceof Double ? vf.createLiteral(((Double)value).doubleValue()) : (value instanceof Boolean ? vf.createLiteral(((Boolean)value).booleanValue()) : vf.createLiteral(value.toString())))));
        return val;
    }
}

