/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.impl.DefaultTreeContentRect;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.FL;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.AreaTreeInfo;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelLoader;
import cz.vutbr.fit.layout.rdf.ModelLoaderBase;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.model.RDFArea;
import cz.vutbr.fit.layout.rdf.model.RDFAreaTree;
import cz.vutbr.fit.layout.rdf.model.RDFBox;
import cz.vutbr.fit.layout.rdf.model.RDFPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaModelLoader
extends ModelLoaderBase
implements ModelLoader {
    private static Logger log = LoggerFactory.getLogger(AreaModelLoader.class);
    private int next_id;

    public AreaModelLoader(IRIFactory iriFactory) {
        super(iriFactory);
    }

    @Override
    public Artifact loadArtifact(IRI artifactIri, RDFArtifactRepository artifactRepo) throws RepositoryException {
        this.loadTags(artifactRepo);
        return this.constructAreaTree(artifactRepo, artifactIri);
    }

    private RDFAreaTree constructAreaTree(RDFArtifactRepository artifactRepo, IRI areaTreeIri) throws RepositoryException {
        this.next_id = 0;
        Model artifactModel = artifactRepo.getStorage().getSubjectModel((Resource)areaTreeIri);
        if (artifactModel.size() > 0) {
            RDFArea root;
            AreaTreeInfo atreeInfo = new AreaTreeInfo(artifactModel, areaTreeIri);
            IRI pageIri = this.getSourcePageIri(artifactModel, areaTreeIri);
            IRI parentIri = this.getPredicateIriValue(artifactModel, areaTreeIri, FL.hasParentArtifact);
            RDFAreaTree atree = new RDFAreaTree(parentIri, pageIri);
            atreeInfo.applyToAreaTree(atree);
            RDFPage sourcePage = null;
            if (pageIri != null) {
                sourcePage = this.getSourcePage(pageIri, artifactRepo);
            }
            LinkedHashMap<IRI, RDFArea> areaUris = new LinkedHashMap<IRI, RDFArea>();
            Repository repo = artifactRepo.getStorage().getRepository();
            try (RepositoryConnection con = repo.getConnection();){
                root = this.constructVisualAreaTree(con, sourcePage, atree, areaTreeIri, areaUris, atree.getAdditionalStatements());
            }
            if (root != null) {
                this.recursiveUpdateTopologies((Area)root);
                atree.setRoot((Area)root);
                atree.setAreaIris(areaUris);
                return atree;
            }
            return null;
        }
        return null;
    }

    private RDFArea constructVisualAreaTree(RepositoryConnection con, RDFPage sourcePage, RDFAreaTree atree, IRI areaTreeIri, Map<IRI, RDFArea> areas, Collection<Statement> additionalStatements) throws RepositoryException {
        HashSet<Resource> areaIris = new HashSet<Resource>();
        try (RepositoryResult result = con.getStatements(null, RDF.TYPE, (Value)SEGM.Area, new Resource[]{areaTreeIri});){
            for (Statement st : result) {
                areaIris.add(st.getSubject());
            }
        }
        ArrayList<RDFArea> areaList = new ArrayList<RDFArea>(areaIris.size());
        for (Resource res : areaIris) {
            if (!(res instanceof IRI)) continue;
            RDFArea area = this.createArea(con, sourcePage, areaTreeIri, (IRI)res, additionalStatements);
            area.setAreaTree((AreaTree)atree);
            areaList.add(area);
        }
        areaList.sort(new Comparator<RDFArea>(){

            @Override
            public int compare(RDFArea o1, RDFArea o2) {
                return o1.getDocumentOrder() - o2.getDocumentOrder();
            }
        });
        for (RDFArea area : areaList) {
            areas.put(area.getIri(), area);
        }
        HashSet rootAreas = new HashSet(areaList);
        try (RepositoryResult result = con.getStatements(null, SEGM.isChildOf, null, new Resource[]{areaTreeIri});){
            for (Statement st : result) {
                if (!(st.getSubject() instanceof IRI) || !(st.getObject() instanceof IRI)) continue;
                RDFArea parent = areas.get(st.getObject());
                RDFArea child = areas.get(st.getSubject());
                if (parent == null || child == null) continue;
                parent.appendChild((Area)child);
                rootAreas.remove(child);
            }
        }
        if (rootAreas.size() == 1) {
            RDFArea root = (RDFArea)rootAreas.iterator().next();
            this.checkChildOrderValues(root);
            return root;
        }
        log.error("Strange number of root areas: {}", (Object)((Object)rootAreas).toString());
        return null;
    }

    private RDFArea createArea(RepositoryConnection con, RDFPage sourcePage, IRI areaTreeIri, IRI areaIri, Collection<Statement> additionalStatements) throws RepositoryException {
        RDFArea area = new RDFArea(new Rectangular(), areaIri);
        area.setId(this.next_id++);
        area.setDocumentOrder(-1);
        HashMap<IRI, Float> tagSupport = new HashMap<IRI, Float>();
        ModelLoaderBase.RDFTextStyle style = new ModelLoaderBase.RDFTextStyle();
        try (RepositoryResult result = con.getStatements((Resource)areaIri, null, null, new Resource[]{areaTreeIri});){
            for (Statement st : result) {
                Value value;
                IRI pred = st.getPredicate();
                if (this.processContentRectProperty(con, pred, value = st.getObject(), (DefaultTreeContentRect<?>)area) || this.processStyleProperty(pred, value, style)) continue;
                if (RDFS.LABEL.equals((Object)pred)) {
                    String name = value.stringValue();
                    area.setName(name);
                    continue;
                }
                if (BOX.documentOrder.equals((Object)pred)) {
                    if (!(value instanceof Literal)) continue;
                    area.setDocumentOrder(((Literal)value).intValue());
                    continue;
                }
                if (BOX.bounds.equals((Object)pred)) {
                    Rectangular rect;
                    if (!(value instanceof IRI) || (rect = this.createBounds(con, (IRI)value)) == null) continue;
                    area.setBounds(rect);
                    continue;
                }
                if (SEGM.containsBox.equals((Object)pred)) {
                    RDFBox box;
                    if (!(value instanceof IRI) || sourcePage == null || (box = sourcePage.findBoxByIri((IRI)value)) == null) continue;
                    area.addBox((Box)box);
                    continue;
                }
                if (SEGM.hasTag.equals((Object)pred)) {
                    Tag tag;
                    if (!(value instanceof IRI) || tagSupport.containsKey(value) || (tag = this.getTag((IRI)value)) == null) continue;
                    area.addTag(tag, 1.0f);
                    continue;
                }
                if (SEGM.tagSupport.equals((Object)pred)) {
                    Tag tag;
                    if (!(value instanceof IRI)) continue;
                    IRI tsUri = (IRI)value;
                    IRI tagUri = null;
                    Float support = null;
                    try (RepositoryResult tsResult = con.getStatements((Resource)tsUri, null, null, new Resource[0]);){
                        for (Statement sst : tsResult) {
                            if (SEGM.hasTag.equals((Object)sst.getPredicate()) && sst.getObject() instanceof IRI) {
                                tagUri = (IRI)sst.getObject();
                                continue;
                            }
                            if (!SEGM.support.equals((Object)sst.getPredicate()) || !(sst.getObject() instanceof Literal)) continue;
                            support = Float.valueOf(((Literal)sst.getObject()).floatValue());
                        }
                    }
                    if (tagUri == null || support == null || (tag = this.getTag(tagUri)) == null) continue;
                    area.removeTag(tag);
                    area.addTag(tag, support.floatValue());
                    tagSupport.put(tagUri, support);
                    continue;
                }
                additionalStatements.add(st);
            }
        }
        area.setTextStyle(style.toTextStyle());
        area.sortBoxes();
        return area;
    }

    private void recursiveUpdateTopologies(Area root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveUpdateTopologies((Area)root.getChildAt(i));
        }
        root.updateTopologies();
    }
}

