/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.ContentImage;
import cz.vutbr.fit.layout.model.ContentObject;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelBuilder;
import cz.vutbr.fit.layout.rdf.ModelBuilderBase;
import cz.vutbr.fit.layout.rdf.Serialization;
import cz.vutbr.fit.layout.rdf.model.RDFContentImage;
import cz.vutbr.fit.layout.rdf.model.RDFPage;
import java.net.URL;
import java.util.Base64;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;

public class BoxModelBuilder
extends ModelBuilderBase
implements ModelBuilder {
    private ValueFactory vf = SimpleValueFactory.getInstance();
    private int objIdCnt;

    public BoxModelBuilder(IRIFactory iriFactory) {
        super(iriFactory);
    }

    @Override
    public Model createGraph(Artifact artifact) {
        return this.createPageGraph((Page)artifact, artifact.getIri());
    }

    private Model createPageGraph(Page page, IRI pageNode) {
        Set<Statement> toadd;
        String baseUrl = page.getSourceURL().toString();
        LinkedHashModel graph = new LinkedHashModel();
        this.objIdCnt = 1;
        this.addArtifactData((Model)graph, (Artifact)page);
        graph.add((Resource)pageNode, BOX.width, (Value)this.vf.createLiteral(page.getWidth()), new Resource[0]);
        graph.add((Resource)pageNode, BOX.height, (Value)this.vf.createLiteral(page.getHeight()), new Resource[0]);
        graph.add((Resource)pageNode, BOX.sourceUrl, (Value)this.vf.createLiteral(baseUrl), new Resource[0]);
        if (page.getTitle() != null) {
            graph.add((Resource)pageNode, BOX.title, (Value)this.vf.createLiteral(page.getTitle()), new Resource[0]);
        }
        if (page.getPngImage() != null) {
            graph.add((Resource)pageNode, BOX.pngImage, (Value)this.vf.createLiteral(Base64.getEncoder().encodeToString(page.getPngImage())), new Resource[0]);
        }
        Box root = page.getRoot();
        this.insertBox(root, pageNode, (Model)graph);
        this.insertChildBoxes(root, pageNode, (Model)graph);
        if (page instanceof RDFPage && (toadd = ((RDFPage)page).getAdditionalStatements()) != null) {
            graph.addAll(toadd);
        }
        return graph;
    }

    private void insertChildBoxes(Box root, IRI pageNode, Model graph) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            Box child = (Box)root.getChildAt(i);
            this.insertBox(child, pageNode, graph);
            this.insertChildBoxes(child, pageNode, graph);
        }
    }

    private void insertBox(Box box, IRI pageNode, Model graph) {
        IRI individual = this.getBoxIri(pageNode, box);
        graph.add((Resource)individual, RDF.TYPE, (Value)BOX.Box, new Resource[0]);
        graph.add((Resource)individual, BOX.documentOrder, (Value)this.vf.createLiteral(box.getOrder()), new Resource[0]);
        graph.add((Resource)individual, BOX.visible, (Value)this.vf.createLiteral(box.isVisible()), new Resource[0]);
        graph.add((Resource)individual, BOX.belongsTo, (Value)pageNode, new Resource[0]);
        if (box.getParent() != null) {
            graph.add((Resource)individual, BOX.isChildOf, (Value)this.getBoxIri(pageNode, (Box)box.getParent()), new Resource[0]);
        }
        if (box.getSourceNodeId() != null) {
            graph.add((Resource)individual, BOX.sourceXPath, (Value)this.vf.createLiteral(box.getSourceNodeId()), new Resource[0]);
        }
        if (box.getTagName() != null) {
            graph.add((Resource)individual, BOX.htmlTagName, (Value)this.vf.createLiteral(box.getTagName()), new Resource[0]);
        }
        if (box.getDisplayType() != null) {
            graph.add((Resource)individual, BOX.displayType, (Value)this.vf.createLiteral(Serialization.displayTypeString(box.getDisplayType())), new Resource[0]);
        }
        Map attrs = box.getAttributes();
        for (Map.Entry attr : attrs.entrySet()) {
            IRI attrUri = this.insertAttribute(individual, (String)attr.getKey(), (String)attr.getValue(), graph);
            graph.add((Resource)individual, BOX.hasAttribute, (Value)attrUri, new Resource[0]);
        }
        this.insertBounds(individual, BOX.bounds, "b", box.getBounds(), graph);
        this.insertBounds(individual, BOX.visualBounds, "v", box.getVisualBounds(), graph);
        this.insertBounds(individual, BOX.contentBounds, "c", box.getContentBounds(), graph);
        this.addContentRectData(graph, individual, (ContentRect)box);
        if (box.getBackgroundImagePng() != null) {
            IRI objuri = this.getIriFactory().createContentObjectURI(pageNode, this.objIdCnt++);
            RDFContentImage image = new RDFContentImage(objuri);
            image.setPngData(box.getBackgroundImagePng());
            this.insertImage(graph, image, objuri);
            graph.add((Resource)individual, BOX.hasBackgroundImage, (Value)objuri, new Resource[0]);
        }
        if (box.getType() == Box.Type.TEXT_CONTENT) {
            graph.add((Resource)individual, BOX.text, (Value)this.vf.createLiteral(box.getText()), new Resource[0]);
        } else if (box.getType() == Box.Type.REPLACED_CONTENT) {
            ContentObject obj = box.getContentObject();
            IRI objuri = this.getIriFactory().createContentObjectURI(pageNode, this.objIdCnt++);
            if (obj instanceof ContentImage) {
                this.insertImage(graph, (ContentImage)obj, objuri);
                graph.add((Resource)individual, BOX.containsObject, (Value)objuri, new Resource[0]);
            } else {
                graph.add((Resource)objuri, RDF.TYPE, (Value)BOX.ContentObject, new Resource[0]);
                graph.add((Resource)individual, BOX.containsObject, (Value)objuri, new Resource[0]);
            }
        }
        graph.add((Resource)individual, BOX.color, (Value)this.vf.createLiteral(Serialization.colorString(box.getColor())), new Resource[0]);
        graph.add((Resource)individual, BOX.fontFamily, (Value)this.vf.createLiteral(box.getFontFamily()), new Resource[0]);
        this.addTextStyle(graph, individual, (ContentRect)box);
    }

    private void insertImage(Model graph, ContentImage image, IRI imageIri) {
        byte[] imageData;
        graph.add((Resource)imageIri, RDF.TYPE, (Value)BOX.Image, new Resource[0]);
        URL url = image.getUrl();
        if (url != null) {
            graph.add((Resource)imageIri, BOX.imageUrl, (Value)this.vf.createLiteral(url.toString()), new Resource[0]);
        }
        if ((imageData = image.getPngData()) != null) {
            graph.add((Resource)imageIri, BOX.imageData, (Value)this.vf.createLiteral(Base64.getEncoder().encodeToString(imageData)), new Resource[0]);
        }
    }

    private IRI insertAttribute(IRI boxUri, String name, String value, Model graph) {
        IRI uri = this.getIriFactory().createAttributeURI(boxUri, name);
        graph.add((Resource)uri, RDFS.LABEL, (Value)this.vf.createLiteral(name), new Resource[0]);
        graph.add((Resource)uri, RDF.VALUE, (Value)this.vf.createLiteral(value), new Resource[0]);
        return uri;
    }
}

