/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf.model;

import cz.vutbr.fit.layout.impl.DefaultAreaTree;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.rdf.model.RDFArea;
import cz.vutbr.fit.layout.rdf.model.RDFArtifact;
import cz.vutbr.fit.layout.rdf.model.RDFLogicalArea;
import cz.vutbr.fit.layout.rdf.model.RDFResource;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;

public class RDFAreaTree
extends DefaultAreaTree
implements RDFResource,
RDFArtifact {
    private Set<Statement> additionalStatements;
    protected Map<IRI, RDFArea> areaIris;
    protected Map<IRI, RDFLogicalArea> logicalAreaIris;

    public RDFAreaTree(IRI parentIri, IRI pageIri) {
        super(parentIri, pageIri);
    }

    public RDFAreaTree(AreaTree src, IRI targetIri) {
        super(src);
        this.setIri(targetIri);
    }

    public Map<IRI, RDFArea> getAreaIris() {
        return this.areaIris;
    }

    public void setAreaIris(Map<IRI, RDFArea> areaIris) {
        this.areaIris = areaIris;
    }

    public RDFArea findAreaByIri(IRI iri) {
        if (this.areaIris != null) {
            return this.areaIris.get(iri);
        }
        return null;
    }

    public Map<IRI, RDFLogicalArea> getLogicalAreaIris() {
        return this.logicalAreaIris;
    }

    public void setLogicalAreaUris(Map<IRI, RDFLogicalArea> logicalAreaIris) {
        this.logicalAreaIris = logicalAreaIris;
    }

    public RDFLogicalArea findLogicalAreaByUri(IRI iri) {
        if (this.logicalAreaIris != null) {
            return this.logicalAreaIris.get(iri);
        }
        return null;
    }

    public void setAdditionalStatements(Set<Statement> additionalStatements) {
        this.additionalStatements = additionalStatements;
    }

    @Override
    public Set<Statement> getAdditionalStatements() {
        return this.additionalStatements;
    }

    @Override
    public void recompute() {
        if (this.getRoot() != null) {
            this.recursiveInvalidateStyle(this.getRoot());
        }
    }

    private void recursiveInvalidateStyle(Area root) {
        root.childrenChanged();
        for (Area child : root.getChildren()) {
            this.recursiveInvalidateStyle(child);
        }
    }
}

