/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Border;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.TextStyle;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.FL;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelTransformer;
import cz.vutbr.fit.layout.rdf.Serialization;
import cz.vutbr.fit.layout.rdf.model.RDFResource;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;

public class ModelBuilderBase
extends ModelTransformer {
    private ValueFactory vf = SimpleValueFactory.getInstance();

    public ModelBuilderBase(IRIFactory iriFactory) {
        super(iriFactory);
    }

    public void addArtifactData(Model graph, Artifact a) {
        IRI node = a.getIri();
        graph.add((Resource)node, RDF.TYPE, (Value)a.getArtifactType(), new Resource[0]);
        if (a.getParentIri() != null) {
            graph.add((Resource)node, FL.hasParentArtifact, (Value)a.getParentIri(), new Resource[0]);
        }
        if (a.getLabel() != null) {
            graph.add((Resource)node, RDFS.LABEL, (Value)this.vf.createLiteral(a.getLabel()), new Resource[0]);
        }
        if (a.getCreatedOn() != null) {
            graph.add((Resource)node, FL.createdOn, (Value)this.vf.createLiteral(a.getCreatedOn()), new Resource[0]);
        }
        if (a.getCreator() != null) {
            graph.add((Resource)node, FL.creator, (Value)this.vf.createLiteral(a.getCreator()), new Resource[0]);
        }
        if (a.getCreatorParams() != null) {
            graph.add((Resource)node, FL.creatorParams, (Value)this.vf.createLiteral(a.getCreatorParams()), new Resource[0]);
        }
    }

    public void addContentRectData(Model graph, IRI rectIri, ContentRect rect) {
        if (rect.getBackgroundColor() != null) {
            graph.add((Resource)rectIri, BOX.backgroundColor, (Value)this.vf.createLiteral(Serialization.colorString(rect.getBackgroundColor())), new Resource[0]);
        }
        graph.add((Resource)rectIri, BOX.backgroundSeparated, (Value)this.vf.createLiteral(rect.isBackgroundSeparated()), new Resource[0]);
        this.insertBorders(rect, rectIri, graph);
        this.insertSameAs(rect, rectIri, graph);
    }

    public void addTextStyle(Model graph, IRI rectIri, ContentRect rect) {
        TextStyle textStyle = rect.getTextStyle();
        graph.add((Resource)rectIri, BOX.fontSize, (Value)this.vf.createLiteral(textStyle.getFontSize()), new Resource[0]);
        graph.add((Resource)rectIri, BOX.fontWeight, (Value)this.vf.createLiteral(textStyle.getFontWeight()), new Resource[0]);
        graph.add((Resource)rectIri, BOX.fontStyle, (Value)this.vf.createLiteral(textStyle.getFontStyle()), new Resource[0]);
        graph.add((Resource)rectIri, BOX.underline, (Value)this.vf.createLiteral(textStyle.getUnderline()), new Resource[0]);
        graph.add((Resource)rectIri, BOX.lineThrough, (Value)this.vf.createLiteral(textStyle.getLineThrough()), new Resource[0]);
        graph.add((Resource)rectIri, BOX.contentLength, (Value)this.vf.createLiteral(textStyle.getContentLength()), new Resource[0]);
    }

    public IRI insertBounds(IRI boxIri, IRI property, String type, Rectangular bounds, Model graph) {
        IRI iri = this.getIriFactory().createBoundsURI(boxIri, type);
        graph.add((Resource)boxIri, property, (Value)iri, new Resource[0]);
        graph.add((Resource)iri, BOX.positionX, (Value)this.vf.createLiteral(bounds.getX1()), new Resource[0]);
        graph.add((Resource)iri, BOX.positionY, (Value)this.vf.createLiteral(bounds.getY1()), new Resource[0]);
        graph.add((Resource)iri, BOX.width, (Value)this.vf.createLiteral(bounds.getWidth()), new Resource[0]);
        graph.add((Resource)iri, BOX.height, (Value)this.vf.createLiteral(bounds.getHeight()), new Resource[0]);
        return iri;
    }

    public void insertBorders(ContentRect box, IRI boxIri, Model graph) {
        if (box.getBorderStyle(Border.Side.TOP) != null && box.hasTopBorder()) {
            IRI btop = this.insertBorder(box.getBorderStyle(Border.Side.TOP), boxIri, "top", graph);
            graph.add((Resource)boxIri, BOX.hasTopBorder, (Value)btop, new Resource[0]);
        }
        if (box.getBorderStyle(Border.Side.RIGHT) != null && box.hasRightBorder()) {
            IRI bright = this.insertBorder(box.getBorderStyle(Border.Side.RIGHT), boxIri, "right", graph);
            graph.add((Resource)boxIri, BOX.hasRightBorder, (Value)bright, new Resource[0]);
        }
        if (box.getBorderStyle(Border.Side.BOTTOM) != null && box.hasBottomBorder()) {
            IRI bbottom = this.insertBorder(box.getBorderStyle(Border.Side.BOTTOM), boxIri, "bottom", graph);
            graph.add((Resource)boxIri, BOX.hasBottomBorder, (Value)bbottom, new Resource[0]);
        }
        if (box.getBorderStyle(Border.Side.LEFT) != null && box.hasLeftBorder()) {
            IRI bleft = this.insertBorder(box.getBorderStyle(Border.Side.LEFT), boxIri, "left", graph);
            graph.add((Resource)boxIri, BOX.hasLeftBorder, (Value)bleft, new Resource[0]);
        }
    }

    public IRI insertBorder(Border border, IRI boxUri, String side, Model graph) {
        IRI uri = this.getIriFactory().createBorderURI(boxUri, side);
        graph.add((Resource)uri, RDF.TYPE, (Value)BOX.Border, new Resource[0]);
        graph.add((Resource)uri, BOX.borderWidth, (Value)this.vf.createLiteral(border.getWidth()), new Resource[0]);
        graph.add((Resource)uri, BOX.borderStyle, (Value)this.vf.createLiteral(border.getStyle().toString()), new Resource[0]);
        graph.add((Resource)uri, BOX.borderColor, (Value)this.vf.createLiteral(Serialization.colorString(border.getColor())), new Resource[0]);
        return uri;
    }

    public void insertSameAs(ContentRect node, IRI nodeIri, Model graph) {
        IRI objIri;
        Object obj = node.getUserAttribute("core.node.sameAs", Object.class);
        if (obj != null && obj instanceof RDFResource && (objIri = ((RDFResource)obj).getIri()) != null) {
            graph.add((Resource)nodeIri, OWL.SAMEAS, (Value)objIri, new Resource[0]);
            graph.add((Resource)objIri, OWL.SAMEAS, (Value)nodeIri, new Resource[0]);
        }
    }
}

