/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.impl.BaseArtifact;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.rdf.RDFArtifactInfo;
import cz.vutbr.fit.layout.rdf.model.RDFPage;
import java.util.Base64;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;

public class PageInfo
extends RDFArtifactInfo {
    private int width = -1;
    private int height = -1;
    private String title;
    private String url;
    private byte[] pngImage;

    public PageInfo(Model model, IRI pageIri) {
        super(model, pageIri);
    }

    @Override
    protected boolean processStatement(Statement st) {
        boolean sret = super.processStatement(st);
        boolean ret = true;
        if (st.getPredicate().equals((Object)BOX.title)) {
            this.title = st.getObject().stringValue();
        } else if (st.getPredicate().equals((Object)BOX.sourceUrl)) {
            this.url = st.getObject().stringValue();
        } else if (st.getPredicate().equals((Object)BOX.pngImage)) {
            String dataStr = st.getObject().stringValue();
            try {
                this.pngImage = Base64.getDecoder().decode(dataStr);
            }
            catch (IllegalArgumentException e) {
                this.pngImage = null;
            }
        } else {
            ret = false;
        }
        return sret || ret;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public byte[] getPngImage() {
        return this.pngImage;
    }

    public void applyToPage(RDFPage page) {
        this.applyToArtifact((BaseArtifact)page);
        page.setWidth(this.width);
        page.setHeight(this.height);
        page.setTitle(this.getTitle());
        if (this.getPngImage() != null) {
            page.setPngImage(this.getPngImage());
        }
        page.setAdditionalStatements(this.getAdditionalStatements());
    }
}

