/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.api.ServiceConfig;
import cz.vutbr.fit.layout.api.Tagger;
import cz.vutbr.fit.layout.api.TaggerConfig;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFTaggerConfig
implements TaggerConfig {
    private static Logger log = LoggerFactory.getLogger(RDFTaggerConfig.class);
    private RDFArtifactRepository repo;

    public RDFTaggerConfig(RDFArtifactRepository repo) {
        this.repo = repo;
    }

    public Map<Tag, Tagger> getTaggers() {
        HashMap<Tag, Tagger> ret = new HashMap<Tag, Tagger>();
        Collection<Tag> tags = this.repo.getTags();
        for (Tag tag : tags) {
            Tagger tagger = this.getTaggerForTag(tag);
            if (tagger == null) continue;
            ret.put(tag, tagger);
        }
        return ret;
    }

    public Tagger getTaggerForTag(Tag tag) {
        Value val = this.repo.getStorage().getPropertyValue((Resource)tag.getIri(), SEGM.tagger);
        if (val instanceof IRI) {
            return this.loadTagger((IRI)val);
        }
        return null;
    }

    private Tagger loadTagger(IRI taggerIri) {
        ServiceConfig conf = this.repo.getStorage().loadServiceConfig(taggerIri);
        if (conf != null) {
            try {
                Class<?> tcls = Class.forName(conf.getServiceId());
                Object inst = tcls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (inst instanceof Tagger) {
                    Tagger tagger = (Tagger)inst;
                    for (Map.Entry param : conf.getParams().entrySet()) {
                        tagger.setParam((String)param.getKey(), param.getValue());
                    }
                    return tagger;
                }
                log.error("Service {} used in {} is not a tagger", (Object)conf.getServiceId(), (Object)taggerIri);
                return null;
            }
            catch (Exception e) {
                log.error("Couldn't create instance of tagger {} : {}", (Object)conf.getServiceId(), (Object)e.getMessage());
                return null;
            }
        }
        log.warn("Couldn't find usable tagger definition: {}", (Object)taggerIri);
        return null;
    }
}

