/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.impl.DefaultTreeContentRect;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.GenericTreeNode;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelLoader;
import cz.vutbr.fit.layout.rdf.ModelLoaderBase;
import cz.vutbr.fit.layout.rdf.PageInfo;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.Serialization;
import cz.vutbr.fit.layout.rdf.model.RDFBox;
import cz.vutbr.fit.layout.rdf.model.RDFContentImage;
import cz.vutbr.fit.layout.rdf.model.RDFContentObject;
import cz.vutbr.fit.layout.rdf.model.RDFPage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxModelLoader
extends ModelLoaderBase
implements ModelLoader {
    private static Logger log = LoggerFactory.getLogger(BoxModelLoader.class);
    private int next_id;

    public BoxModelLoader(IRIFactory iriFactory) {
        super(iriFactory);
    }

    @Override
    public Artifact loadArtifact(IRI artifactIri, RDFArtifactRepository artifactRepo) throws RepositoryException {
        return this.constructPage(artifactRepo, artifactIri);
    }

    private RDFPage constructPage(RDFArtifactRepository artifactRepo, IRI pageIri) throws RepositoryException {
        this.next_id = 0;
        Model pageModel = artifactRepo.getStorage().getSubjectModel((Resource)pageIri);
        if (pageModel.size() > 0) {
            URL srcURL;
            PageInfo info = new PageInfo(pageModel, pageIri);
            try {
                srcURL = new URL(info.getUrl());
            }
            catch (MalformedURLException e) {
                try {
                    srcURL = new URL("http://no/url");
                }
                catch (MalformedURLException e1) {
                    srcURL = null;
                }
            }
            RDFPage page = new RDFPage(srcURL);
            info.applyToPage(page);
            LinkedHashMap<IRI, RDFBox> boxes = new LinkedHashMap<IRI, RDFBox>();
            RDFBox root = null;
            Repository repo = artifactRepo.getStorage().getRepository();
            try (RepositoryConnection con = repo.getConnection();){
                root = this.constructBoxTree(con, pageIri, boxes, page.getAdditionalStatements());
            }
            if (root != null) {
                this.checkChildOrderValues(root);
                page.setRoot((Box)root);
                page.setBoxIris(boxes);
                if (page.getWidth() == -1 && page.getHeight() == -1) {
                    page.setWidth(root.getWidth());
                    page.setHeight(root.getHeight());
                }
                return page;
            }
            return null;
        }
        return null;
    }

    private RDFBox constructBoxTree(RepositoryConnection con, IRI pageIri, Map<IRI, RDFBox> boxes, Collection<Statement> additionalStatements) throws RepositoryException {
        HashSet<Resource> boxIris = new HashSet<Resource>();
        try (RepositoryResult result = con.getStatements(null, RDF.TYPE, (Value)BOX.Box, new Resource[]{pageIri});){
            for (Statement st : result) {
                boxIris.add(st.getSubject());
            }
        }
        ArrayList<RDFBox> boxList = new ArrayList<RDFBox>(boxIris.size());
        for (Resource res : boxIris) {
            if (!(res instanceof IRI)) continue;
            RDFBox box = this.createBox(con, pageIri, (IRI)res, additionalStatements);
            boxList.add(box);
        }
        boxList.sort(new Comparator<RDFBox>(){

            @Override
            public int compare(RDFBox o1, RDFBox o2) {
                return o1.getDocumentOrder() - o2.getDocumentOrder();
            }
        });
        for (RDFBox box : boxList) {
            boxes.put(box.getIri(), box);
        }
        ArrayList rootBoxes = new ArrayList(boxList);
        try (RepositoryResult result = con.getStatements(null, BOX.isChildOf, null, new Resource[]{pageIri});){
            for (Statement st : result) {
                if (!(st.getSubject() instanceof IRI) || !(st.getObject() instanceof IRI)) continue;
                RDFBox parent = boxes.get(st.getObject());
                RDFBox child = boxes.get(st.getSubject());
                if (parent == null || child == null) continue;
                parent.appendChild((GenericTreeNode)child);
                rootBoxes.remove(child);
            }
        }
        if (rootBoxes.size() == 1) {
            return (RDFBox)rootBoxes.get(0);
        }
        log.error("Strange number of root boxes: {}", (Object)((Object)rootBoxes).toString());
        return null;
    }

    private RDFBox createBox(RepositoryConnection con, IRI pageIri, IRI boxIri, Collection<Statement> additionalStatements) throws RepositoryException {
        RDFBox box = new RDFBox(boxIri);
        box.setId(this.next_id++);
        box.setOrder(-1);
        box.setTagName("");
        box.setType(Box.Type.ELEMENT);
        box.setDisplayType(Box.DisplayType.BLOCK);
        ModelLoaderBase.RDFTextStyle style = new ModelLoaderBase.RDFTextStyle();
        try (RepositoryResult result = con.getStatements((Resource)boxIri, null, null, new Resource[]{pageIri});){
            for (Statement st : result) {
                Rectangular rect;
                Value value;
                IRI pred = st.getPredicate();
                if (this.processContentRectProperty(con, pred, value = st.getObject(), (DefaultTreeContentRect<?>)box) || this.processStyleProperty(pred, value, style)) continue;
                if (BOX.documentOrder.equals((Object)pred)) {
                    if (!(value instanceof Literal)) continue;
                    box.setOrder(((Literal)value).intValue());
                    continue;
                }
                if (BOX.visible.equals((Object)pred)) {
                    if (!(value instanceof Literal)) continue;
                    box.setVisible(((Literal)value).booleanValue());
                    continue;
                }
                if (BOX.hasBackgroundImage.equals((Object)pred)) {
                    if (!(value instanceof IRI)) continue;
                    RDFContentImage image = this.loadImage(con, (IRI)value);
                    box.setBackgroundImagePng(image.getPngData());
                    continue;
                }
                if (BOX.color.equals((Object)pred)) {
                    box.setColor(Serialization.decodeHexColor(value.stringValue()));
                    continue;
                }
                if (BOX.fontFamily.equals((Object)pred)) {
                    if (!(value instanceof Literal)) continue;
                    box.setFontFamily(value.stringValue());
                    continue;
                }
                if (BOX.text.equals((Object)pred)) {
                    if (box.getType() != Box.Type.REPLACED_CONTENT) {
                        box.setType(Box.Type.TEXT_CONTENT);
                    }
                    box.setDisplayType(null);
                    box.setOwnText(value.stringValue());
                    continue;
                }
                if (BOX.containsObject.equals((Object)pred)) {
                    RDFContentObject obj;
                    box.setType(Box.Type.REPLACED_CONTENT);
                    if (!(value instanceof IRI)) continue;
                    Value valueType = this.getPropertyValue(con, (Resource)((IRI)value), RDF.TYPE);
                    if (BOX.Image.equals((Object)valueType)) {
                        obj = this.loadImage(con, (IRI)value);
                        box.setContentObject(obj);
                        continue;
                    }
                    obj = new RDFContentObject((IRI)value);
                    box.setContentObject(obj);
                    continue;
                }
                if (BOX.bounds.equals((Object)pred)) {
                    if (!(value instanceof IRI) || (rect = this.createBounds(con, (IRI)value)) == null) continue;
                    box.setBounds(rect);
                    continue;
                }
                if (BOX.visualBounds.equals((Object)pred)) {
                    if (!(value instanceof IRI) || (rect = this.createBounds(con, (IRI)value)) == null) continue;
                    box.setVisualBounds(rect);
                    continue;
                }
                if (BOX.contentBounds.equals((Object)pred)) {
                    if (!(value instanceof IRI) || (rect = this.createBounds(con, (IRI)value)) == null) continue;
                    box.setContentBounds(rect);
                    continue;
                }
                if (BOX.sourceXPath.equals((Object)pred)) {
                    box.setSourceNodeId(value.stringValue());
                    continue;
                }
                if (BOX.htmlTagName.equals((Object)pred)) {
                    box.setTagName(value.stringValue());
                    continue;
                }
                if (BOX.displayType.equals((Object)pred)) {
                    Box.DisplayType type = Serialization.decodeDisplayType(value.stringValue());
                    if (type == null) continue;
                    box.setDisplayType(type);
                    continue;
                }
                if (BOX.hasAttribute.equals((Object)pred)) {
                    Map.Entry<String, String> attr;
                    if (!(value instanceof IRI) || (attr = this.createAttribute(con, (IRI)value)) == null) continue;
                    box.setAttribute(attr.getKey(), attr.getValue());
                    continue;
                }
                additionalStatements.add(st);
            }
        }
        box.setTextStyle(style.toTextStyle());
        return box;
    }

    private RDFContentImage loadImage(RepositoryConnection con, IRI imageIri) {
        Value dataVal;
        RDFContentImage obj = new RDFContentImage(imageIri);
        Value urlVal = this.getPropertyValue(con, (Resource)imageIri, BOX.imageUrl);
        if (urlVal != null && urlVal instanceof Literal) {
            try {
                obj.setUrl(((Literal)urlVal).stringValue());
            }
            catch (MalformedURLException e) {
                log.error(e.getMessage());
            }
        }
        if ((dataVal = this.getPropertyValue(con, (Resource)imageIri, BOX.imageData)) != null && dataVal instanceof Literal) {
            String dataStr = dataVal.stringValue();
            try {
                obj.setPngData(Base64.getDecoder().decode(dataStr));
            }
            catch (IllegalArgumentException e) {
                obj.setPngData(null);
            }
        }
        return obj;
    }
}

