/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.impl.BaseArtifact;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.RDFArtifactInfo;
import cz.vutbr.fit.layout.rdf.model.RDFChunkSet;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;

public class ChunkSetInfo
extends RDFArtifactInfo {
    private IRI areaTreeIri;
    private IRI pageIri;

    public ChunkSetInfo(Model model, IRI areaTreeIri) {
        super(model, areaTreeIri);
    }

    @Override
    protected boolean processStatement(Statement st) {
        boolean sret = super.processStatement(st);
        boolean ret = true;
        if (st.getPredicate().equals((Object)SEGM.hasAreaTree)) {
            if (st.getObject() instanceof IRI) {
                this.areaTreeIri = (IRI)st.getObject();
            }
        } else if (st.getPredicate().equals((Object)SEGM.hasSourcePage)) {
            if (st.getObject() instanceof IRI) {
                this.pageIri = (IRI)st.getObject();
            }
        } else {
            ret = false;
        }
        return sret || ret;
    }

    public IRI getAreaTreeIri() {
        return this.areaTreeIri;
    }

    public void setAreaTreeIri(IRI areaTreeIri) {
        this.areaTreeIri = areaTreeIri;
    }

    public IRI getPageIri() {
        return this.pageIri;
    }

    public void setPageIri(IRI pageIri) {
        this.pageIri = pageIri;
    }

    public void applyToChunkSet(RDFChunkSet cset) {
        this.applyToArtifact((BaseArtifact)cset);
        cset.setAreaTreeIri(this.areaTreeIri);
        cset.setPageIri(this.pageIri);
        cset.setAdditionalStatements(this.getAdditionalStatements());
    }
}

