/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.ChunkSet;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.FL;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.ChunkSetInfo;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelLoader;
import cz.vutbr.fit.layout.rdf.ModelLoaderBase;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.Serialization;
import cz.vutbr.fit.layout.rdf.model.RDFArea;
import cz.vutbr.fit.layout.rdf.model.RDFAreaTree;
import cz.vutbr.fit.layout.rdf.model.RDFBox;
import cz.vutbr.fit.layout.rdf.model.RDFChunkSet;
import cz.vutbr.fit.layout.rdf.model.RDFPage;
import cz.vutbr.fit.layout.rdf.model.RDFTextChunk;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkSetModelLoader
extends ModelLoaderBase
implements ModelLoader {
    private static Logger log = LoggerFactory.getLogger(ChunkSetModelLoader.class);
    private int next_id;

    public ChunkSetModelLoader(IRIFactory iriFactory) {
        super(iriFactory);
    }

    @Override
    public Artifact loadArtifact(IRI artifactIri, RDFArtifactRepository artifactRepo) throws RepositoryException {
        this.loadTags(artifactRepo);
        return this.constructChunkSet(artifactRepo, artifactIri);
    }

    private RDFChunkSet constructChunkSet(RDFArtifactRepository artifactRepo, IRI csetIri) throws RepositoryException {
        this.next_id = 0;
        Model artifactModel = artifactRepo.getStorage().getSubjectModel((Resource)csetIri);
        if (artifactModel.size() > 0) {
            ChunkSetInfo csetInfo = new ChunkSetInfo(artifactModel, csetIri);
            IRI parentIri = this.getPredicateIriValue(artifactModel, csetIri, FL.hasParentArtifact);
            RDFChunkSet cset = new RDFChunkSet(parentIri);
            csetInfo.applyToChunkSet(cset);
            RDFAreaTree sourceAreaTree = null;
            RDFPage sourcePage = null;
            if (cset.getAreaTreeIri() != null) {
                sourceAreaTree = this.getSourceAreaTree(cset.getAreaTreeIri(), artifactRepo);
                if (sourceAreaTree != null) {
                    sourcePage = this.getSourcePage(sourceAreaTree.getPageIri(), artifactRepo);
                }
            } else {
                log.error("ChunkSet {} has no area tree IRI", (Object)String.valueOf(csetIri));
            }
            LinkedHashMap<IRI, RDFTextChunk> chunkUris = new LinkedHashMap<IRI, RDFTextChunk>();
            Repository repo = artifactRepo.getStorage().getRepository();
            Set<TextChunk> chunks = null;
            try (RepositoryConnection con = repo.getConnection();){
                chunks = this.loadChunks(con, sourceAreaTree, sourcePage, csetIri, (ChunkSet)cset, chunkUris, cset.getAdditionalStatements());
            }
            cset.setTextChunks(chunks);
            cset.setChunkIris(chunkUris);
            return cset;
        }
        return null;
    }

    private Set<TextChunk> loadChunks(RepositoryConnection con, RDFAreaTree sourceAreaTree, RDFPage sourcePage, IRI csetIri, ChunkSet cset, Map<IRI, RDFTextChunk> chunkUris, Collection<Statement> additionalStatements) {
        HashSet<Resource> chunkIris = new HashSet<Resource>();
        try (RepositoryResult result = con.getStatements(null, RDF.TYPE, (Value)SEGM.TextChunk, new Resource[]{csetIri});){
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                Statement st = (Statement)iterator.next();
                chunkIris.add(st.getSubject());
            }
        }
        for (Resource res : chunkIris) {
            if (!(res instanceof IRI)) continue;
            RDFTextChunk chunk = this.createChunk(con, sourceAreaTree, sourcePage, csetIri, (IRI)res, additionalStatements);
            chunk.setChunkSet(cset);
            chunkUris.put((IRI)res, chunk);
        }
        HashSet<TextChunk> ret = new HashSet<TextChunk>();
        ret.addAll(chunkUris.values());
        return ret;
    }

    private RDFTextChunk createChunk(RepositoryConnection con, RDFAreaTree sourceAreaTree, RDFPage sourcePage, IRI csetIri, IRI iri, Collection<Statement> additionalStatements) throws RepositoryException {
        RDFTextChunk chunk = new RDFTextChunk(iri);
        chunk.setId(this.next_id++);
        HashMap<IRI, Float> tagSupport = new HashMap<IRI, Float>();
        ModelLoaderBase.RDFTextStyle style = new ModelLoaderBase.RDFTextStyle();
        try (RepositoryResult result = con.getStatements((Resource)iri, null, null, new Resource[]{csetIri});){
            for (Statement st : result) {
                IRI pred = st.getPredicate();
                Value value = st.getObject();
                if (SEGM.text.equals((Object)pred)) {
                    chunk.setText(value.stringValue());
                    continue;
                }
                if (BOX.documentOrder.equals((Object)pred)) {
                    if (!(value instanceof Literal)) continue;
                    chunk.setDocumentOrder(((Literal)value).intValue());
                    continue;
                }
                if (BOX.backgroundColor.equals((Object)pred)) {
                    String bgColor = value.stringValue();
                    chunk.setEffectiveBackgroundColor(Serialization.decodeHexColor(bgColor));
                    continue;
                }
                if (BOX.color.equals((Object)pred)) {
                    chunk.setColor(Serialization.decodeHexColor(value.stringValue()));
                    continue;
                }
                if (BOX.fontFamily.equals((Object)pred)) {
                    if (!(value instanceof Literal)) continue;
                    chunk.setFontFamily(value.stringValue());
                    continue;
                }
                if (SEGM.hasSourceArea.equals((Object)pred)) {
                    if (!(value instanceof IRI)) continue;
                    RDFArea a = sourceAreaTree.findAreaByIri((IRI)value);
                    if (a != null) {
                        chunk.setSourceArea((Area)a);
                        continue;
                    }
                    log.error("hasSourceArea points to a non-existent area {}", (Object)value.toString());
                    continue;
                }
                if (SEGM.hasSourceBox.equals((Object)pred)) {
                    if (!(value instanceof IRI)) continue;
                    RDFBox b = sourcePage.findBoxByIri((IRI)value);
                    if (b != null) {
                        chunk.setSourceBox((Box)b);
                        continue;
                    }
                    log.error("hasSourceBox points to a non-existent box {}", (Object)value.toString());
                    continue;
                }
                if (BOX.bounds.equals((Object)pred)) {
                    Rectangular rect;
                    if (!(value instanceof IRI) || (rect = this.createBounds(con, (IRI)value)) == null) continue;
                    chunk.setBounds(rect);
                    continue;
                }
                if (SEGM.hasTag.equals((Object)pred)) {
                    Tag tag;
                    if (!(value instanceof IRI) || tagSupport.containsKey(value) || (tag = this.getTag((IRI)value)) == null) continue;
                    chunk.addTag(tag, 1.0f);
                    continue;
                }
                if (SEGM.tagSupport.equals((Object)pred)) {
                    Tag tag;
                    if (!(value instanceof IRI)) continue;
                    IRI tsUri = (IRI)value;
                    IRI tagUri = null;
                    Float support = null;
                    try (RepositoryResult tsResult = con.getStatements((Resource)tsUri, null, null, new Resource[0]);){
                        for (Statement sst : tsResult) {
                            if (SEGM.hasTag.equals((Object)sst.getPredicate()) && sst.getObject() instanceof IRI) {
                                tagUri = (IRI)sst.getObject();
                                continue;
                            }
                            if (!SEGM.support.equals((Object)sst.getPredicate()) || !(sst.getObject() instanceof Literal)) continue;
                            support = Float.valueOf(((Literal)sst.getObject()).floatValue());
                        }
                    }
                    if (tagUri == null || support == null || (tag = this.getTag(tagUri)) == null) continue;
                    chunk.removeTag(tag);
                    chunk.addTag(tag, support.floatValue());
                    tagSupport.put(tagUri, support);
                    continue;
                }
                if (this.processStyleProperty(pred, value, style)) continue;
                additionalStatements.add(st);
            }
        }
        chunk.setTextStyle(style.toTextStyle());
        return chunk;
    }
}

