/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Metadata;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataExtractor {
    private static Logger log = LoggerFactory.getLogger(MetadataExtractor.class);

    public static Model extract(Artifact artifact) {
        LinkedHashModel model = new LinkedHashModel();
        if (artifact.getMetadata() != null) {
            for (Metadata metadata : artifact.getMetadata()) {
                if ("application/ld+json".equals(metadata.getType()) && metadata.getContent() instanceof String) {
                    MetadataExtractor.parseJSON((String)metadata.getContent(), (Model)model);
                    continue;
                }
                log.warn("Skipping unknown metadata of type {}", (Object)metadata.getType());
            }
        }
        return model;
    }

    private static void parseJSON(String src, Model model) {
        RDFParser rdfParser = Rio.createParser((RDFFormat)RDFFormat.JSONLD);
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        rdfParser.getParserConfig().set(BasicParserSettings.SKOLEMIZE_ORIGIN, (Object)"http://fitlayout.github.io/resource/");
        try {
            rdfParser.parse((Reader)new StringReader(src));
        }
        catch (IOException | RDFHandlerException | RDFParseException e) {
            log.error("Could not parse metadata: {}", (Object)e.getMessage());
        }
    }
}

