/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.impl.DefaultTag;
import cz.vutbr.fit.layout.impl.DefaultTreeContentRect;
import cz.vutbr.fit.layout.model.Border;
import cz.vutbr.fit.layout.model.GenericTreeNode;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TextStyle;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelTransformer;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.Serialization;
import cz.vutbr.fit.layout.rdf.StorageException;
import cz.vutbr.fit.layout.rdf.model.RDFAreaTree;
import cz.vutbr.fit.layout.rdf.model.RDFOrderedResource;
import cz.vutbr.fit.layout.rdf.model.RDFPage;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModelLoaderBase
extends ModelTransformer {
    private static Logger log = LoggerFactory.getLogger(ModelLoaderBase.class);
    private Map<IRI, Tag> repositoryTags;

    public ModelLoaderBase(IRIFactory iriFactory) {
        super(iriFactory);
    }

    protected IRI getPredicateIriValue(Model model, IRI subject, IRI predicate) {
        Iterable typeStatements = model.getStatements((Resource)subject, predicate, null, new Resource[0]);
        for (Statement st : typeStatements) {
            if (!(st.getObject() instanceof IRI)) continue;
            return (IRI)st.getObject();
        }
        return null;
    }

    protected boolean processContentRectProperty(RepositoryConnection con, IRI pred, Value value, DefaultTreeContentRect<?> rect) {
        boolean ret = true;
        if (BOX.backgroundColor.equals((Object)pred)) {
            String bgColor = value.stringValue();
            rect.setBackgroundColor(Serialization.decodeHexColor(bgColor));
        } else if (BOX.backgroundSeparated.equals((Object)pred)) {
            if (value instanceof Literal) {
                rect.setBackgroundSeparated(((Literal)value).booleanValue());
            }
        } else if (BOX.hasBottomBorder.equals((Object)pred)) {
            if (value instanceof IRI) {
                Border border = this.createBorder(con, (IRI)value);
                rect.setBorderStyle(Border.Side.BOTTOM, border);
            }
        } else if (BOX.hasLeftBorder.equals((Object)pred)) {
            if (value instanceof IRI) {
                Border border = this.createBorder(con, (IRI)value);
                rect.setBorderStyle(Border.Side.LEFT, border);
            }
        } else if (BOX.hasRightBorder.equals((Object)pred)) {
            if (value instanceof IRI) {
                Border border = this.createBorder(con, (IRI)value);
                rect.setBorderStyle(Border.Side.RIGHT, border);
            }
        } else if (BOX.hasTopBorder.equals((Object)pred)) {
            if (value instanceof IRI) {
                Border border = this.createBorder(con, (IRI)value);
                rect.setBorderStyle(Border.Side.TOP, border);
            }
        } else {
            ret = false;
        }
        return ret;
    }

    protected boolean processStyleProperty(IRI pred, Value value, RDFTextStyle style) {
        boolean ret = true;
        if (BOX.underline.equals((Object)pred)) {
            if (value instanceof Literal) {
                style.underline = ((Literal)value).floatValue();
            }
        } else if (BOX.lineThrough.equals((Object)pred)) {
            if (value instanceof Literal) {
                style.lineThrough = ((Literal)value).floatValue();
            }
        } else if (BOX.fontSize.equals((Object)pred)) {
            if (value instanceof Literal) {
                style.fontSize = ((Literal)value).floatValue();
            }
        } else if (BOX.fontStyle.equals((Object)pred)) {
            if (value instanceof Literal) {
                style.fontStyle = ((Literal)value).floatValue();
            }
        } else if (BOX.fontWeight.equals((Object)pred)) {
            if (value instanceof Literal) {
                style.fontWeight = ((Literal)value).floatValue();
            }
        } else if (BOX.contentLength.equals((Object)pred)) {
            if (value instanceof Literal) {
                style.contentLength = ((Literal)value).intValue();
            }
        } else {
            ret = false;
        }
        return ret;
    }

    protected Border createBorder(RepositoryConnection con, IRI borderIri) {
        Border ret = new Border();
        try (RepositoryResult result = con.getStatements((Resource)borderIri, null, null, new Resource[0]);){
            for (Statement st : result) {
                IRI pred = st.getPredicate();
                Value value = st.getObject();
                if (BOX.borderColor.equals((Object)pred)) {
                    ret.setColor(Serialization.decodeHexColor(value.stringValue()));
                    continue;
                }
                if (BOX.borderWidth.equals((Object)pred)) {
                    if (!(value instanceof Literal)) continue;
                    ret.setWidth(((Literal)value).intValue());
                    continue;
                }
                if (!BOX.borderStyle.equals((Object)pred)) continue;
                String style = value.stringValue();
                try {
                    ret.setStyle(Border.Style.valueOf((String)style));
                }
                catch (IllegalArgumentException r) {
                    log.error("Invalid style value: {}", (Object)style);
                }
            }
        }
        return ret;
    }

    protected Map.Entry<String, String> createAttribute(RepositoryConnection con, IRI attrIri) {
        String name = null;
        String avalue = null;
        try (RepositoryResult result = con.getStatements((Resource)attrIri, null, null, new Resource[0]);){
            for (Statement st : result) {
                IRI pred = st.getPredicate();
                Value value = st.getObject();
                if (RDFS.LABEL.equals((Object)pred)) {
                    if (!(value instanceof Literal)) continue;
                    name = ((Literal)value).stringValue();
                    continue;
                }
                if (!RDF.VALUE.equals((Object)pred) || !(value instanceof Literal)) continue;
                avalue = ((Literal)value).stringValue();
            }
        }
        if (name != null && avalue != null) {
            return new AbstractMap.SimpleEntry<Object, Object>(name, avalue);
        }
        return null;
    }

    protected Rectangular createBounds(RepositoryConnection con, IRI boundsIri) {
        Integer x = null;
        Integer y = null;
        Integer width = null;
        Integer height = null;
        try (RepositoryResult result = con.getStatements((Resource)boundsIri, null, null, new Resource[0]);){
            for (Statement st : result) {
                IRI pred = st.getPredicate();
                Value value = st.getObject();
                if (BOX.positionX.equals((Object)pred)) {
                    if (!(value instanceof Literal)) continue;
                    x = ((Literal)value).intValue();
                    continue;
                }
                if (BOX.positionY.equals((Object)pred)) {
                    if (!(value instanceof Literal)) continue;
                    y = ((Literal)value).intValue();
                    continue;
                }
                if (BOX.width.equals((Object)pred)) {
                    if (!(value instanceof Literal)) continue;
                    width = ((Literal)value).intValue();
                    continue;
                }
                if (!BOX.height.equals((Object)pred) || !(value instanceof Literal)) continue;
                height = ((Literal)value).intValue();
            }
        }
        if (x != null && y != null && width != null && height != null) {
            return new Rectangular(x.intValue(), y.intValue(), x + width - 1, y + height - 1);
        }
        return null;
    }

    protected IRI getSourcePageIri(Model model, IRI areaTreeIri) {
        return this.getPredicateIriValue(model, areaTreeIri, SEGM.hasSourcePage);
    }

    protected RDFPage getSourcePage(IRI pageIri, ArtifactRepository repo) {
        RDFPage page = (RDFPage)repo.getArtifact(pageIri);
        return page;
    }

    protected IRI getSourceAreaTreeIri(Model model, IRI logicalTreeIri) {
        return this.getPredicateIriValue(model, logicalTreeIri, SEGM.hasAreaTree);
    }

    protected RDFAreaTree getSourceAreaTree(IRI areaTreeIri, ArtifactRepository repo) {
        RDFAreaTree atree = (RDFAreaTree)repo.getArtifact(areaTreeIri);
        return atree;
    }

    protected void loadTags(RDFArtifactRepository repo) {
        this.repositoryTags = new HashMap<IRI, Tag>();
        for (Tag tag : repo.getTags()) {
            this.repositoryTags.put(tag.getIri(), tag);
        }
    }

    protected Tag getTag(IRI tagIri) {
        Tag tag;
        if (this.repositoryTags == null) {
            this.repositoryTags = new HashMap<IRI, Tag>();
        }
        if ((tag = this.repositoryTags.get(tagIri)) == null) {
            tag = new DefaultTag(tagIri, "x", tagIri.getLocalName());
            this.repositoryTags.put(tagIri, tag);
        }
        return tag;
    }

    protected String getDataPropertyUnion(String[] dataObjectProperties) {
        StringBuilder ret = new StringBuilder();
        for (String p : dataObjectProperties) {
            if (ret.length() > 0) {
                ret.append(" UNION ");
            }
            ret.append("{?a ").append(p).append(" ?s}");
        }
        return ret.toString();
    }

    protected Model execArtifactReadQuery(RDFArtifactRepository artifactRepo, String query) {
        return artifactRepo.getStorage().executeSafeQuery(query, (IsolationLevel)IsolationLevels.SNAPSHOT_READ);
    }

    public Value getPropertyValue(RepositoryConnection con, Resource subject, IRI predicate) throws StorageException {
        Value ret = null;
        try (RepositoryResult result = con.getStatements(subject, predicate, null, true, new Resource[0]);){
            if (result.hasNext()) {
                ret = ((Statement)result.next()).getObject();
            }
        }
        return ret;
    }

    protected <T extends GenericTreeNode<T>> void checkChildOrderValues(GenericTreeNode<T> root) {
        int offset = 0;
        for (GenericTreeNode childArea : root.getChildren()) {
            RDFOrderedResource child = (RDFOrderedResource)childArea;
            if (child.getDocumentOrder() == -1) {
                int newOrder = -1;
                if (childArea.getChildCount() != 0) {
                    newOrder = ((RDFOrderedResource)childArea.getChildAt(0)).getDocumentOrder();
                }
                if (newOrder == -1) {
                    newOrder = ((RDFOrderedResource)root).getDocumentOrder() + offset;
                    ++offset;
                }
                child.setDocumentOrder(newOrder);
            }
            this.checkChildOrderValues(childArea);
        }
        root.getChildren().sort(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((RDFOrderedResource)o1).getDocumentOrder() - ((RDFOrderedResource)o2).getDocumentOrder();
            }
        });
    }

    protected static class RDFTextStyle {
        public float fontSize = 0.0f;
        public float fontWeight = 0.0f;
        public float fontStyle = 0.0f;
        public float underline = 0.0f;
        public float lineThrough = 0.0f;
        public int contentLength = 1;

        protected RDFTextStyle() {
        }

        public TextStyle toTextStyle() {
            TextStyle ret = new TextStyle();
            ret.setFontSizeSum(this.fontSize * (float)this.contentLength);
            ret.setFontWeightSum(this.fontWeight * (float)this.contentLength);
            ret.setFontStyleSum(this.fontStyle * (float)this.contentLength);
            ret.setUnderlineSum(this.underline * (float)this.contentLength);
            ret.setLineThroughSum(this.lineThrough * (float)this.contentLength);
            ret.setContentLength(this.contentLength);
            return ret;
        }
    }
}

