/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.api.IRIDecoder;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.FL;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.AreaModelBuilder;
import cz.vutbr.fit.layout.rdf.AreaModelLoader;
import cz.vutbr.fit.layout.rdf.BoxModelBuilder;
import cz.vutbr.fit.layout.rdf.BoxModelLoader;
import cz.vutbr.fit.layout.rdf.ChunkSetModelBuilder;
import cz.vutbr.fit.layout.rdf.ChunkSetModelLoader;
import cz.vutbr.fit.layout.rdf.DefaultIRIFactory;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.LogicalAreaModelBuilder;
import cz.vutbr.fit.layout.rdf.LogicalAreaModelLoader;
import cz.vutbr.fit.layout.rdf.MetadataExtractor;
import cz.vutbr.fit.layout.rdf.ModelBuilder;
import cz.vutbr.fit.layout.rdf.ModelLoader;
import cz.vutbr.fit.layout.rdf.RDFArtifactInfo;
import cz.vutbr.fit.layout.rdf.RDFIRIDecoder;
import cz.vutbr.fit.layout.rdf.RDFStorage;
import cz.vutbr.fit.layout.rdf.SavedQuery;
import cz.vutbr.fit.layout.rdf.StorageException;
import cz.vutbr.fit.layout.rdf.model.RDFTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFArtifactRepository
implements ArtifactRepository {
    private static final String METADATA_CONTEXT_PREFIX = "file://resources/rdf/";
    private static final String SAVED_QUERIES_CONTEXT = "http://fitlayout.github.io/queries/";
    private static Logger log = LoggerFactory.getLogger(RDFArtifactRepository.class);
    public static String METADATA_SUFFIX = "meta";
    private static String[] owls = new String[]{"render.owl", "segmentation.owl", "fitlayout.owl", "mapping.owl"};
    private boolean readOnly = false;
    private RDFStorage storage;
    private IRIFactory iriFactory;
    private RDFIRIDecoder iriDecoder;
    private Map<IRI, ModelBuilder> modelBuilders;
    private Map<IRI, ModelLoader> modelLoaders;

    public RDFArtifactRepository(RDFStorage storage) {
        this.storage = storage;
        this.iriFactory = new DefaultIRIFactory();
        this.iriDecoder = new RDFIRIDecoder();
        this.initDefaultModelBuilders();
        this.init();
    }

    public static RDFArtifactRepository createMemory(String path) {
        return new RDFArtifactRepository(RDFStorage.createMemory(path));
    }

    public static RDFArtifactRepository createNative(String path) {
        return new RDFArtifactRepository(RDFStorage.createNative(path));
    }

    public static RDFArtifactRepository createHTTP(String serverUrl, String repositoryId) {
        return new RDFArtifactRepository(RDFStorage.createHTTP(serverUrl, repositoryId));
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void disconnect() {
        this.storage.close();
    }

    public RDFStorage getStorage() {
        return this.storage;
    }

    public IRIDecoder getIriDecoder() {
        return this.iriDecoder;
    }

    public IRIFactory getIriFactory() {
        return this.iriFactory;
    }

    public void setIriFactory(IRIFactory iriFactory) {
        this.iriFactory = iriFactory;
    }

    public void init() {
        if (!this.isInitialized() && System.getProperty("fitlayout.rdf.disableAutoInit") == null) {
            this.initMetadata();
            if (!this.isInitialized()) {
                log.error("Repository init failed");
            }
        }
    }

    public boolean isInitialized() {
        Value val = this.getStorage().getPropertyValue((Resource)BOX.Page, RDF.TYPE);
        return val != null;
    }

    public boolean initMetadata() {
        log.info("Initializing repository metadata");
        try {
            for (String owl : owls) {
                SimpleValueFactory vf = SimpleValueFactory.getInstance();
                IRI context = vf.createIRI(METADATA_CONTEXT_PREFIX + owl);
                String owlFile = RDFArtifactRepository.loadResource("/rdf/" + owl);
                this.getStorage().importXML(owlFile, context);
            }
            this.getStorage().addNamespace("r", "http://fitlayout.github.io/resource/");
        }
        catch (Exception e) {
            log.error("Could import metadata: {}", (Throwable)e);
            return false;
        }
        return this.isInitialized();
    }

    private static String loadResource(String filePath) {
        try (Scanner scanner = new Scanner(RDFArtifactRepository.class.getResourceAsStream(filePath), "UTF-8");){
            scanner.useDelimiter("\\A");
            String string = scanner.next();
            return string;
        }
    }

    public void clearMetadata() {
        log.info("Clearing repository metadata");
        try {
            for (String owl : owls) {
                SimpleValueFactory vf = SimpleValueFactory.getInstance();
                IRI context = vf.createIRI(METADATA_CONTEXT_PREFIX + owl);
                this.getStorage().clear(context);
            }
        }
        catch (Exception e) {
            log.error("Could clear metadata: {}", (Throwable)e);
        }
    }

    public Collection<IRI> getArtifactIRIs() throws StorageException {
        try {
            String query = this.iriDecoder.declarePrefixes() + "SELECT DISTINCT ?pg WHERE {  ?pg rdf:type ?type .   ?type rdfs:subClassOf fl:Artifact .   OPTIONAL { ?pg fl:createdOn ?ctime }   bind(coalesce(?ctime, 0) as ?time) } ORDER BY ?time";
            List<BindingSet> data = this.storage.executeSafeTupleQuery(query);
            ArrayList<IRI> ret = new ArrayList<IRI>(data.size());
            for (BindingSet binding : data) {
                Binding b = binding.getBinding("pg");
                ret.add((IRI)b.getValue());
            }
            return ret;
        }
        catch (RDF4JException e) {
            throw new StorageException(e);
        }
    }

    public Collection<IRI> getArtifactIRIs(IRI pageIri) throws StorageException {
        try {
            String query = this.iriDecoder.declarePrefixes() + "SELECT DISTINCT ?pg WHERE {  ?pg segm:hasSourcePage <" + pageIri.toString() + "> .   ?pg rdf:type ?type .   ?type rdfs:subClassOf fl:Artifact .   OPTIONAL { ?pg fl:createdOn ?ctime }   bind(coalesce(?ctime, 0) as ?time) } ORDER BY ?time";
            List<BindingSet> data = this.storage.executeSafeTupleQuery(query);
            ArrayList<IRI> ret = new ArrayList<IRI>(data.size());
            for (BindingSet binding : data) {
                Binding b = binding.getBinding("pg");
                ret.add((IRI)b.getValue());
            }
            return ret;
        }
        catch (RDF4JException e) {
            throw new StorageException(e);
        }
    }

    public Collection<Artifact> getArtifactInfo() throws StorageException {
        try {
            String query = this.iriDecoder.declarePrefixes() + "SELECT DISTINCT ?pg ?type ?label ?time ?parent ?creator ?creatorParams\nWHERE {\n  ?pg rdf:type ?type .\n  ?type rdfs:subClassOf fl:Artifact .\n  ?pg rdfs:label ?label .\n  ?pg fl:creator ?creator .\n  ?pg fl:creatorParams ?creatorParams .\n  OPTIONAL { ?pg fl:hasParentArtifact ?parent } .\n  OPTIONAL { ?pg fl:createdOn ?time }\n} ORDER BY ?time\n";
            List<BindingSet> data = this.storage.executeSafeTupleQuery(query);
            ArrayList<Artifact> ret = new ArrayList<Artifact>(data.size());
            for (BindingSet binding : data) {
                ret.add((Artifact)new RDFArtifactInfo(binding));
            }
            return ret;
        }
        catch (RDF4JException e) {
            throw new StorageException(e);
        }
    }

    public Collection<Artifact> getArtifactInfoOld() {
        Collection<IRI> iris = this.getArtifactIRIs();
        ArrayList<Artifact> ret = new ArrayList<Artifact>(iris.size());
        for (IRI iri : iris) {
            Model artifactModel = this.getStorage().getSubjectModel((Resource)iri);
            if (artifactModel.size() <= 0) continue;
            RDFArtifactInfo info = new RDFArtifactInfo(artifactModel, iri, false);
            ret.add((Artifact)info);
        }
        return ret;
    }

    public Artifact getArtifact(IRI artifactIri) {
        IRI type = this.getArtifactType(artifactIri);
        if (type != null) {
            ModelLoader loader = this.getModelLoader(type);
            if (loader != null) {
                Artifact artifact = loader.loadArtifact(artifactIri, this);
                return artifact;
            }
            log.warn("No loader available for type {}", (Object)type);
        } else {
            log.warn("Artifact {} has no type", (Object)artifactIri);
        }
        return null;
    }

    public Model getArtifactModel(IRI artifactIri) {
        return this.storage.getContextModel((Resource)artifactIri);
    }

    public void addArtifact(Artifact artifact) {
        if (this.isReadOnly()) {
            throw new StorageException("Read-only repository");
        }
        if (artifact.getIri() == null) {
            artifact.setIri(this.createArtifactIri(artifact));
        }
        log.debug("STORING {}", (Object)artifact);
        ModelBuilder builder = this.getModelBuilder(artifact.getArtifactType());
        if (builder != null) {
            Model graph = builder.createGraph(artifact);
            try {
                this.storage.insertGraph(graph, artifact.getIri());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (artifact.getMetadata() != null) {
                IRI metaIRI = this.getMetadataIRI(artifact.getIri());
                Model metadata = MetadataExtractor.extract(artifact);
                this.storage.insertGraph(metadata, metaIRI);
            }
        } else {
            log.error("Could not find RDF model builder for artifact {}, type {}", (Object)artifact, (Object)artifact.getArtifactType());
        }
    }

    public IRI createArtifactIri(Artifact artifact) {
        long seq = this.storage.getNextSequenceValue(this.iriFactory.createSequenceURI("page"));
        IRI pageUri = this.iriFactory.createArtifactIri(seq);
        return pageUri;
    }

    public void replaceArtifact(IRI artifactIri, Artifact artifact) {
        if (this.isReadOnly()) {
            throw new StorageException("Read-only repository");
        }
        artifact.setIri(artifactIri);
        this.clearArtifact(artifactIri);
        this.addArtifact(artifact);
    }

    public void removeArtifact(IRI artifactIri) {
        if (this.isReadOnly()) {
            throw new StorageException("Read-only repository");
        }
        ArrayList<Artifact> derived = new ArrayList<Artifact>();
        this.findDerivedArtifacts(artifactIri, this.getArtifactInfo(), derived);
        for (Artifact a : derived) {
            this.clearArtifact(a.getIri());
        }
        this.clearArtifact(artifactIri);
    }

    public IRI getMetadataIRI(IRI artifactIri) {
        return this.iriFactory.createRelatedIri(artifactIri, METADATA_SUFFIX);
    }

    private void clearArtifact(IRI artifactIri) {
        this.storage.clear(artifactIri);
        this.storage.clear(this.getMetadataIRI(artifactIri));
    }

    private void findDerivedArtifacts(IRI artifactIri, Collection<Artifact> artifacts, List<Artifact> dest) {
        for (Artifact a : artifacts) {
            if (!artifactIri.equals((Object)a.getParentIri())) continue;
            this.findDerivedArtifacts(a.getIri(), artifacts, dest);
            dest.add(a);
        }
    }

    public void clear() {
        if (this.isReadOnly()) {
            throw new StorageException("Read-only repository");
        }
        this.storage.clear();
    }

    public void clearContext(IRI contextIri) {
        if (this.isReadOnly()) {
            throw new StorageException("Read-only repository");
        }
        this.storage.clear(contextIri);
    }

    private IRI getArtifactType(IRI artifactIRI) {
        Value val = this.storage.getPropertyValue((Resource)artifactIRI, RDF.TYPE);
        if (val.isIRI()) {
            return (IRI)val;
        }
        return null;
    }

    protected void initDefaultModelBuilders() {
        this.modelBuilders = new HashMap<IRI, ModelBuilder>();
        this.modelLoaders = new HashMap<IRI, ModelLoader>();
        this.addModelBuilder(BOX.Page, new BoxModelBuilder(this.iriFactory));
        this.addModelBuilder(SEGM.AreaTree, new AreaModelBuilder(this.iriFactory));
        this.addModelBuilder(SEGM.LogicalAreaTree, new LogicalAreaModelBuilder(this.iriFactory));
        this.addModelBuilder(SEGM.ChunkSet, new ChunkSetModelBuilder(this.iriFactory));
        this.addModelLoader(BOX.Page, new BoxModelLoader(this.iriFactory));
        this.addModelLoader(SEGM.AreaTree, new AreaModelLoader(this.iriFactory));
        this.addModelLoader(SEGM.LogicalAreaTree, new LogicalAreaModelLoader(this.iriFactory));
        this.addModelLoader(SEGM.ChunkSet, new ChunkSetModelLoader(this.iriFactory));
    }

    public void addModelBuilder(IRI artifactType, ModelBuilder builder) {
        this.modelBuilders.put(artifactType, builder);
    }

    public ModelBuilder getModelBuilder(IRI artifactType) {
        return this.modelBuilders.get(artifactType);
    }

    public void addModelLoader(IRI artifactType, ModelLoader builder) {
        this.modelLoaders.put(artifactType, builder);
    }

    public ModelLoader getModelLoader(IRI artifactType) {
        return this.modelLoaders.get(artifactType);
    }

    public Collection<RDFTag> getTags() throws StorageException {
        try {
            String query = this.iriDecoder.declarePrefixes() + "SELECT ?tag ?name ?type ?context WHERE {   GRAPH ?context {    ?tag segm:name ?name .     ?tag segm:type ?type .     ?tag rdf:type segm:Tag }}";
            List<BindingSet> data = this.storage.executeSafeTupleQuery(query);
            ArrayList<RDFTag> ret = new ArrayList<RDFTag>(data.size());
            for (BindingSet binding : data) {
                Binding bIri = binding.getBinding("tag");
                Binding bName = binding.getBinding("name");
                Binding bType = binding.getBinding("type");
                Binding bContext = binding.getBinding("context");
                if (bIri == null || bName == null || bType == null || bContext == null || !(bIri.getValue() instanceof IRI) || !(bContext.getValue() instanceof IRI)) continue;
                RDFTag tag = new RDFTag((IRI)bIri.getValue(), bType.getValue().stringValue(), bName.getValue().stringValue(), (IRI)bContext.getValue());
                ret.add(tag);
            }
            return ret;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public void saveQuery(SavedQuery query) {
        if (query.getIri() == null) {
            long seq = this.storage.getNextSequenceValue(this.iriFactory.createSequenceURI("query"));
            IRI iri = this.iriFactory.createSavedQueryURI(seq);
            query.setIri(iri);
        } else {
            this.deleteSavedQuery(query.getIri());
        }
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        IRI context = vf.createIRI(SAVED_QUERIES_CONTEXT);
        this.storage.add(query.getIri(), RDF.TYPE, FL.SavedQuery, context);
        this.storage.addValue(query.getIri(), RDFS.LABEL, query.getTitle(), context);
        this.storage.addValue(query.getIri(), RDF.VALUE, query.getQueryString(), context);
    }

    public Map<IRI, SavedQuery> getSavedQueries() {
        try {
            String query = this.iriDecoder.declarePrefixes() + "SELECT ?query ?label ?queryString WHERE {     ?query rdfs:label ?label .     ?query rdf:value ?queryString .     ?query rdf:type fl:SavedQuery }";
            HashMap<IRI, SavedQuery> ret = new HashMap<IRI, SavedQuery>();
            List<BindingSet> data = this.storage.executeSafeTupleQuery(query);
            for (BindingSet binding : data) {
                Binding bIri = binding.getBinding("query");
                Binding bLabel = binding.getBinding("label");
                Binding bQuery = binding.getBinding("queryString");
                if (bIri == null || bLabel == null || bQuery == null || !(bIri.getValue() instanceof IRI)) continue;
                SavedQuery newq = new SavedQuery((IRI)bIri.getValue(), bLabel.getValue().stringValue(), bQuery.getValue().stringValue());
                ret.put(newq.getIri(), newq);
            }
            return ret;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public SavedQuery getSavedQueryByTitle(String title) {
        Map<IRI, SavedQuery> all = this.getSavedQueries();
        for (SavedQuery q : all.values()) {
            if (!q.getTitle().trim().equals(title.trim())) continue;
            return q;
        }
        return null;
    }

    public void deleteSavedQuery(IRI iri) {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        IRI context = vf.createIRI(SAVED_QUERIES_CONTEXT);
        this.storage.removeStatements((Resource)iri, null, null, new Resource[]{context});
    }
}

