/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf.fn;

import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.rdf.fn.SpatialFunction;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

public abstract class RectComparisonFunction
extends SpatialFunction
implements Function {
    private String fname;

    public RectComparisonFunction(String fname) {
        this.fname = fname;
    }

    public String getURI() {
        return "http://fitlayout.github.io/fn/" + this.fname;
    }

    protected abstract boolean evaluateForBoxes(Rectangular var1, Rectangular var2);

    public Value evaluate(TripleSource tripleSource, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 2) {
            throw new ValueExprEvaluationException(this.fname + " function requiresexactly 2 arguments, got " + args.length);
        }
        Resource rect1 = this.getBoundsResource(tripleSource, args[0]);
        Resource rect2 = this.getBoundsResource(tripleSource, args[1]);
        Rectangular b1 = this.getRectangularValue(tripleSource, rect1);
        Rectangular b2 = this.getRectangularValue(tripleSource, rect2);
        boolean ret = this.evaluateForBoxes(b1, b2);
        return Values.literal((boolean)ret);
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        throw new UnsupportedOperationException();
    }
}

