/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf.text;

import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.impl.BaseArtifactService;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.RDFStorage;
import cz.vutbr.fit.layout.rdf.model.RDFArea;
import cz.vutbr.fit.layout.rdf.model.RDFAreaTree;
import java.util.Collections;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.DynamicModel;
import org.eclipse.rdf4j.model.impl.DynamicModelFactory;
import org.eclipse.rdf4j.model.util.Values;

public class CompleteTextProvider
extends BaseArtifactService {
    public String getId() {
        return "FitLayout.CompleteText";
    }

    public String getName() {
        return "Add Complete Text to Areas";
    }

    public String getDescription() {
        return "Adds the a:textContent property to every area in the RDF area tree.";
    }

    public List<Parameter> defineParams() {
        return Collections.emptyList();
    }

    public IRI getConsumes() {
        return SEGM.AreaTree;
    }

    public IRI getProduces() {
        return null;
    }

    public String getCategory() {
        return "Text";
    }

    public Artifact process(Artifact input) throws ServiceException {
        if (input != null && input instanceof RDFAreaTree) {
            ArtifactRepository repo = this.getServiceManager().getArtifactRepository();
            if (repo instanceof RDFArtifactRepository) {
                DynamicModel model = new DynamicModelFactory().createEmptyModel();
                this.recursiveAddText(((AreaTree)input).getRoot(), (Model)model);
                RDFStorage storage = ((RDFArtifactRepository)repo).getStorage();
                storage.insertGraph((Model)model, input.getIri());
                return null;
            }
            throw new ServiceException("RDFArtifactRepository is required for storing the connections");
        }
        throw new ServiceException("Source artifact not specified or not an RDF area tree");
    }

    private void recursiveAddText(Area root, Model model) {
        IRI subj = ((RDFArea)root).getIri();
        String text = root.getText();
        model.add((Resource)subj, SEGM.text, (Value)Values.literal((String)text), new Resource[0]);
        for (Area child : root.getChildren()) {
            this.recursiveAddText(child, model);
        }
    }
}

