/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.chunks;

import cz.vutbr.fit.layout.api.AreaUtils;
import cz.vutbr.fit.layout.api.TagResolver;
import cz.vutbr.fit.layout.impl.DefaultContentLine;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTopology;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TagOccurrence;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.text.chunks.BoxText;
import cz.vutbr.fit.layout.text.chunks.DefaultHint;
import cz.vutbr.fit.layout.text.chunks.SourceBoxList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class HintMultiBox
extends DefaultHint {
    private static final int STEPDIF_THRESHOLD = 2;
    private Tag tag;
    private TagResolver dis;

    public HintMultiBox(Tag tag, TagResolver dis, float support) {
        super("MultiBox", support);
        this.setBlock(true);
        this.tag = tag;
        this.dis = dis;
    }

    @Override
    public SourceBoxList extractBoxes(Area a, SourceBoxList current, Set<Area> processed) {
        Set dtags = this.dis.getAreaTags(a);
        if (dtags.contains(this.tag)) {
            if (a.getParent() != null) {
                AreaTopology topology = ((Area)a.getParent()).getTopology();
                List<Area> lines = this.findConsistentLines(a, topology);
                if (lines.size() > 1) {
                    for (Area aa : lines) {
                        if (aa == a) continue;
                        current.addAll(aa.getBoxes());
                        processed.add(aa);
                    }
                }
                return current;
            }
            return current;
        }
        return current;
    }

    @Override
    public List<TagOccurrence> processOccurrences(BoxText boxText, List<TagOccurrence> occurrences) {
        if (occurrences.isEmpty()) {
            return occurrences;
        }
        ArrayList<TagOccurrence> ret = new ArrayList<TagOccurrence>();
        TagOccurrence occ = new TagOccurrence(boxText.getText(), 0, 1.0f);
        ret.add(occ);
        return ret;
    }

    @Override
    public List<TextChunk> processChunks(Area src, List<TextChunk> areas) {
        DefaultContentLine line = new DefaultContentLine(areas.size());
        line.addAll(areas);
        return areas;
    }

    private List<Area> findConsistentLines(Area a, AreaTopology topology) {
        ArrayList<Area> ret = new ArrayList<Area>();
        ret.add(a);
        Area last = a;
        Rectangular lastr = topology.getPosition((ContentRect)last);
        int laststep = -1;
        boolean found = true;
        while (found) {
            found = false;
            Area next = this.findLineBelow(last, topology);
            if (next == null) continue;
            Rectangular nextr = topology.getPosition((ContentRect)last);
            int step = nextr.getY1() - lastr.getY2();
            int stepdif = Math.abs(laststep - step);
            Set dtags = this.dis.getAreaTags(next);
            if (!dtags.contains(this.tag) || laststep != -1 && stepdif > 2) continue;
            ret.add(next);
            last = next;
            lastr = nextr;
            laststep = step;
            found = true;
        }
        return ret;
    }

    private Area findLineBelow(Area a, AreaTopology topology) {
        ArrayList cands = new ArrayList();
        AreaUtils.findAreasBelow((Area)a, (AreaTopology)topology, cands);
        if (cands.size() == 1) {
            return (Area)cands.get(0);
        }
        return null;
    }
}

