/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.chunks;

import cz.vutbr.fit.layout.api.Tagger;
import cz.vutbr.fit.layout.api.TaggerConfig;
import cz.vutbr.fit.layout.impl.DefaultTextChunk;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TagOccurrence;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.text.chunks.ChunksSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TaggedChunksSource
extends ChunksSource {
    private int idcnt = 1;
    private float minTagSupport;
    private List<TextChunk> chunks;
    private TaggerConfig tagConfig;

    public TaggedChunksSource(TaggerConfig tagConfig, Area root, float minTagSupport) {
        super(root);
        this.minTagSupport = minTagSupport;
        this.tagConfig = tagConfig;
    }

    @Override
    public List<TextChunk> getTextChunks() {
        if (this.chunks == null) {
            this.chunks = new ArrayList<TextChunk>();
            this.recursiveScan(this.getRoot(), this.chunks);
        }
        return this.chunks;
    }

    private void recursiveScan(Area root, List<TextChunk> dest) {
        if (root.isLeaf()) {
            Set supportedTags = root.getSupportedTags(this.minTagSupport);
            if (!supportedTags.isEmpty()) {
                for (Tag t : supportedTags) {
                    List<TextChunk> newAreas = this.createChunksFromTag(root, t);
                    for (TextChunk a : newAreas) {
                        dest.add(a);
                    }
                }
            } else {
                List<TextChunk> newAreas = this.createUntaggedChunks(root);
                for (TextChunk a : newAreas) {
                    dest.add(a);
                }
            }
        } else {
            for (Area child : root.getChildren()) {
                this.recursiveScan(child, dest);
            }
        }
    }

    private List<TextChunk> createChunksFromTag(Area a, Tag t) {
        ArrayList<TextChunk> ret = new ArrayList<TextChunk>();
        Tagger tg = this.tagConfig.getTaggerForTag(t);
        for (Box box : a.getBoxes()) {
            String text = box.getOwnText();
            List occurences = tg.extract(text);
            int last = 0;
            for (TagOccurrence occ : occurences) {
                int pos = occ.getPosition();
                if (pos > last) {
                    TextChunk sepArea = this.createSubstringChunk(a, box, null, text.substring(last, pos), last);
                    ret.add(sepArea);
                }
                TextChunk newArea = this.createSubstringChunk(a, box, t, occ.getText(), pos);
                ret.add(newArea);
                last = pos + occ.getLength();
            }
            if (text.length() <= last) continue;
            TextChunk sepArea = this.createSubstringChunk(a, box, null, text.substring(last), last);
            ret.add(sepArea);
        }
        return ret;
    }

    private List<TextChunk> createUntaggedChunks(Area a) {
        ArrayList<TextChunk> ret = new ArrayList<TextChunk>();
        for (Box box : a.getBoxes()) {
            String text = box.getOwnText();
            if (text == null || text.length() <= 0) continue;
            TextChunk sepArea = this.createSubstringChunk(a, box, null, text, 0);
            ret.add(sepArea);
        }
        return ret;
    }

    private TextChunk createSubstringChunk(Area a, Box box, Tag tag, String occ, int pos) {
        Rectangular r = box.getSubstringBounds(pos, pos + occ.length());
        DefaultTextChunk newChunk = new DefaultTextChunk(r, a, box);
        newChunk.setId(this.idcnt++);
        newChunk.setText(occ);
        if (tag != null) {
            newChunk.setName("<chunk:" + tag.getValue() + "> " + occ);
            newChunk.addTag(tag, a.getTagSupport(tag));
        } else {
            newChunk.setName("<---> " + occ);
        }
        return newChunk;
    }
}

