/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.op;

import cz.vutbr.fit.layout.api.ScriptObject;
import cz.vutbr.fit.layout.api.Tagger;
import cz.vutbr.fit.layout.impl.BaseOperator;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.text.tag.TreeTagger;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagEntitiesOperator
extends BaseOperator
implements ScriptObject {
    private static Logger log = LoggerFactory.getLogger(TagEntitiesOperator.class);
    private TreeTagger tagger;
    private List<Tagger> usedTaggers = new ArrayList<Tagger>();

    public String getId() {
        return "FitLayout.Tag.Entities";
    }

    public String getName() {
        return "Tag entities";
    }

    public String getDescription() {
        return "Recognizes entities in area text using different taggers and adds the corresponding tags to the areas.";
    }

    public String getCategory() {
        return "Classification";
    }

    public void addTagger(Tagger tagger) {
        this.usedTaggers.add(tagger);
    }

    public void addTaggers(Collection<Tagger> taggers) {
        for (Tagger tagger : taggers) {
            this.usedTaggers.add(tagger);
        }
    }

    public void clearTaggers() {
        this.usedTaggers.clear();
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        if (this.usedTaggers.isEmpty()) {
            log.warn("Applying TagEntitiesOperator with no taggers configured");
        }
        this.tagger = new TreeTagger(root);
        for (Tagger t : this.usedTaggers) {
            this.tagger.addTagger(t);
        }
        this.tagger.tagTree();
    }

    public String getVarName() {
        return "entities";
    }

    public void setIO(Reader in, Writer out, Writer err) {
    }
}

