/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.tag;

import cz.vutbr.fit.layout.api.Tagger;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Tag;
import java.util.ArrayList;
import java.util.List;

public class TreeTagger {
    private static final float MIN_SUPPORT = 0.01f;
    protected Area root;
    protected List<Tagger> taggers;

    public TreeTagger(Area root) {
        this.root = root;
        this.taggers = new ArrayList<Tagger>();
    }

    public void addTagger(Tagger tagger) {
        this.taggers.add(tagger);
    }

    public List<Tag> getAllTags() {
        ArrayList<Tag> ret = new ArrayList<Tag>(this.taggers.size());
        for (Tagger tagger : this.taggers) {
            ret.add(tagger.getTag());
        }
        return ret;
    }

    public void tagTree() {
        this.tagSubtree(this.root);
    }

    public void tagSubtree(Area root) {
        this.tagSingleNode(root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.tagSubtree((Area)root.getChildAt(i));
        }
    }

    public void tagSingleNode(Area area) {
        for (Tagger t : this.taggers) {
            float support = t.belongsTo(area);
            if (!(support > 0.01f)) continue;
            area.addTag(t.getTag(), support);
        }
    }
}

