/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.taggers;

import com.joestelmach.natty.DateGroup;
import com.joestelmach.natty.Parser;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TagOccurrence;
import cz.vutbr.fit.layout.text.tag.TextTag;
import cz.vutbr.fit.layout.text.taggers.BaseTagger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTagger
extends BaseTagger {
    private static final float YES = 0.95f;
    private static final float NO = 0.0f;
    private static Map<String, String> dw = new HashMap<String, String>();
    protected Pattern[] dateexpr = new Pattern[]{Pattern.compile("[1-2][0-9][0-9][0-9]\\-[0-9][0-9]\\-[0-9][0-9]")};
    private int dfirst;
    private int dlast;

    public String getId() {
        return "FITLayout.Tag.Date";
    }

    public String getName() {
        return "Dates";
    }

    public String getDescription() {
        return "Identifies dates in the most common formats";
    }

    public TextTag getTag() {
        return new TextTag("date", this);
    }

    public float belongsTo(Area node) {
        if (node.isLeaf()) {
            String[] words;
            String text = node.getText().toLowerCase();
            for (String s : words = text.split("\\s+")) {
                for (Pattern p : this.dateexpr) {
                    if (!p.matcher(s).lookingAt()) continue;
                    return 0.95f;
                }
            }
            words = text.split("\\W+");
            return this.containsDate(words, 1) ? 0.95f : 0.0f;
        }
        return 0.0f;
    }

    public boolean allowsContinuation(Area node) {
        return false;
    }

    public boolean allowsJoining() {
        return false;
    }

    public boolean mayCoexistWith(Tag other) {
        return true;
    }

    public List<TagOccurrence> extract(String src) {
        String[] words;
        ArrayList<TagOccurrence> ret = new ArrayList<TagOccurrence>();
        for (String s : words = src.toLowerCase().split("[^0-9\\-]")) {
            for (Pattern p : this.dateexpr) {
                Matcher match = p.matcher(s);
                if (!match.lookingAt()) continue;
                ret.add(new TagOccurrence(match.group(), match.start(), 0.95f));
            }
        }
        if (ret.isEmpty() && this.findDate(words = Pattern.compile("\\W+", 256).split(src), 1)) {
            Object s = "";
            for (int i = this.dfirst; i <= this.dlast; ++i) {
                if (i != this.dfirst) {
                    s = (String)s + " ";
                }
                s = (String)s + words[i];
            }
            ret.add(new TagOccurrence((String)s, src.indexOf(words[this.dfirst]), 0.95f));
        }
        return ret;
    }

    public List<Date> extractDates(String s) {
        ArrayList<Date> ret = new ArrayList<Date>();
        List<TagOccurrence> srcdates = this.extract(s);
        for (TagOccurrence sdate : srcdates) {
            String[] words = sdate.getText().toLowerCase().split("\\s+");
            if (words.length == 1) {
                ret.add(this.strToDate(words[0]));
                continue;
            }
            String[] sdates = new String[]{"", ""};
            for (int round = 0; round < 2; ++round) {
                short prevtype = -1;
                int order = 0;
                String toadd = null;
                for (int i = 0; i < words.length; ++i) {
                    short type = this.getValueType(words[i]);
                    if (prevtype != -1 && prevtype == type) {
                        ++order;
                    } else {
                        if (toadd != null) {
                            int n = round;
                            sdates[n] = sdates[n] + " " + toadd;
                        }
                        toadd = null;
                        order = 0;
                    }
                    if (order <= round && dw.containsKey(toadd = words[i])) {
                        toadd = dw.get(toadd);
                    }
                    prevtype = type;
                }
                if (toadd == null) continue;
                int n = round;
                sdates[n] = sdates[n] + " " + toadd;
            }
            for (int i = 0; i < 2; ++i) {
                Date d;
                if (sdates[i].isEmpty() || (d = this.strToDate(sdates[i])) == null) continue;
                ret.add(d);
            }
        }
        return ret;
    }

    private Date strToDate(String s) {
        Parser parser = new Parser();
        List groups = parser.parse(s);
        for (DateGroup group : groups) {
            List dates = group.getDates();
            if (dates.size() <= 0) continue;
            return (Date)dates.get(0);
        }
        return null;
    }

    private boolean containsDate(String[] strs, int tolerance) {
        this.dfirst = -1;
        this.dlast = -1;
        int lastdw = -999;
        int lastnum = -999;
        int lastyear = -999;
        for (int i = 0; i < strs.length; ++i) {
            if (!(this.isMonthName(strs[i]) ? (lastdw = i) - lastnum <= tolerance : (this.isYear(strs[i]) ? (lastyear = i) - lastnum <= tolerance : this.isNum(strs[i]) && (lastnum = i) - lastdw <= tolerance))) continue;
            return true;
        }
        return false;
    }

    private boolean findDate(String[] strs, int tolerance) {
        this.dfirst = -1;
        this.dlast = -1;
        int curend = -1;
        int intpos = -1;
        for (int i = 0; i < strs.length; ++i) {
            if (this.isMonthName(strs[i]) || this.isYear(strs[i])) {
                intpos = i;
            }
            if (intpos != i && !this.isNum(strs[i])) continue;
            if (this.isYear(strs[i])) {
                intpos = i;
            }
            if (curend == -1) {
                curend = i;
            } else if (i - curend <= tolerance) {
                curend = i;
            } else {
                if (this.dlast - this.dfirst >= 1 && intpos >= this.dfirst && intpos <= this.dlast) {
                    return true;
                }
                curend = i;
                this.dfirst = i;
                this.dlast = i;
            }
            if (this.dfirst == -1) {
                this.dfirst = curend;
            }
            this.dlast = curend;
        }
        return this.dlast - this.dfirst >= 1;
    }

    private boolean isNum(String s) {
        try {
            Integer.parseInt(this.stripSuffix(s));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private boolean isYear(String s) {
        try {
            int n = Integer.parseInt(s);
            return n > 1900 && n < 2100;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isMonthNum(String s) {
        try {
            int n = Integer.parseInt(this.stripSuffix(s));
            return n >= 1 && n <= 12;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isMonthName(String s) {
        return dw.containsKey(s.toLowerCase());
    }

    private boolean isDayNum(String s) {
        try {
            int n = Integer.parseInt(this.stripSuffix(s));
            return n >= 1 && n <= 31;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private short getValueType(String s) {
        if (this.isMonthName(s)) {
            return 1;
        }
        if (this.isYear(s)) {
            return 2;
        }
        if (this.isMonthNum(s)) {
            return 3;
        }
        if (this.isDayNum(s)) {
            return 4;
        }
        if (this.isNum(s)) {
            return 5;
        }
        return 0;
    }

    private String stripSuffix(String s) {
        String test = s.toLowerCase();
        if (test.endsWith("st") || test.endsWith("nd") || test.endsWith("rd") || test.endsWith("th")) {
            return s.substring(0, s.length() - 2);
        }
        return s;
    }

    static {
        dw.put("jan", "january");
        dw.put("feb", "february");
        dw.put("mar", "march");
        dw.put("apr", "april");
        dw.put("may", "may");
        dw.put("jun", "june");
        dw.put("jul", "july");
        dw.put("aug", "august");
        dw.put("sep", "september");
        dw.put("oct", "october");
        dw.put("nov", "november");
        dw.put("dec", "december");
        dw.put("january", "january");
        dw.put("february", "february");
        dw.put("march", "march");
        dw.put("april", "april");
        dw.put("june", "june");
        dw.put("july", "july");
        dw.put("august", "august");
        dw.put("september", "september");
        dw.put("october", "october");
        dw.put("novebrer", "novebrer");
        dw.put("december", "december");
        dw.put("januar", "january");
        dw.put("februar", "february");
        dw.put("m\u00e4rz", "march");
        dw.put("april", "april");
        dw.put("mai", "may");
        dw.put("juni", "june");
        dw.put("juli", "july");
        dw.put("august", "august");
        dw.put("september", "september");
        dw.put("oktober", "october");
        dw.put("november", "november");
        dw.put("dezember", "december");
        dw.put("janvier", "january");
        dw.put("f\u00e9vrier", "february");
        dw.put("mars", "march");
        dw.put("avril", "april");
        dw.put("mai", "may");
        dw.put("juin", "june");
        dw.put("juillet", "july");
        dw.put("ao\u00fbt", "august");
        dw.put("septembre", "september");
        dw.put("octobre", "october");
        dw.put("novembre", "november");
        dw.put("d\u00e9cembre", "december");
        dw.put("gennaio", "january");
        dw.put("febbraio", "february");
        dw.put("marzo", "march");
        dw.put("aprile", "april");
        dw.put("maggio", "may");
        dw.put("giugno", "june");
        dw.put("luglio", "july");
        dw.put("agosto", "august");
        dw.put("settembre", "september");
        dw.put("ottobre", "october");
        dw.put("novembre", "november");
        dw.put("dicembre", "december");
        dw.put("enero", "january");
        dw.put("febrero", "february");
        dw.put("marzo", "march");
        dw.put("abril", "april");
        dw.put("mayo", "may");
        dw.put("junio", "june");
        dw.put("julio", "july");
        dw.put("agosto", "august");
        dw.put("septiembre", "september");
        dw.put("octubre", "october");
        dw.put("noviembre", "november");
        dw.put("diciembre", "december");
    }
}

