/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.taggers;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TagOccurrence;
import cz.vutbr.fit.layout.text.taggers.BaseTagger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class IntegerTagger
extends BaseTagger {
    private static final float YES = 0.9f;
    private static final float NO = 0.0f;
    private int min;
    private int max;
    private boolean allowsLeadingZero = false;
    private Pattern numexpr;

    public IntegerTagger(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean isAllowsLeadingZero() {
        return this.allowsLeadingZero;
    }

    public void setAllowsLeadingZero(boolean allowsLeadingZero) {
        this.allowsLeadingZero = allowsLeadingZero;
    }

    public String getDescription() {
        return "Numbers from " + this.min + " to " + this.max;
    }

    public float belongsTo(Area node) {
        if (node.isLeaf()) {
            String text = node.getText();
            Matcher match = this.getNumExpr().matcher(text);
            while (match.find()) {
                if (!this.validateMatch(text, match.group(), match.start(), match.end())) continue;
                return 0.9f;
            }
        }
        return 0.0f;
    }

    public boolean allowsContinuation(Area node) {
        return false;
    }

    public boolean allowsJoining() {
        return false;
    }

    public boolean mayCoexistWith(Tag other) {
        return true;
    }

    public List<TagOccurrence> extract(String src) {
        ArrayList<TagOccurrence> ret = new ArrayList<TagOccurrence>();
        Matcher match = this.getNumExpr().matcher(src);
        while (match.find()) {
            if (!this.validateMatch(src, match.group(), match.start(), match.end())) continue;
            ret.add(new TagOccurrence(match.group(), match.start(), 0.9f));
        }
        return ret;
    }

    protected boolean validateMatch(String srcString, String substring, int matchStart, int matchEnd) {
        if (!(matchStart != 0 && Character.isAlphabetic(srcString.codePointAt(matchStart)) || matchEnd != srcString.length() && Character.isAlphabetic(srcString.codePointAt(matchEnd)))) {
            int num = Integer.parseInt(substring);
            return this.validateRange(num);
        }
        return false;
    }

    protected boolean validateRange(int value) {
        return value >= this.getMin() && value <= this.getMax();
    }

    protected Pattern getNumExpr() {
        if (this.numexpr == null) {
            String lead = this.isAllowsLeadingZero() ? "[0-9]" : "[1-9]";
            String re = lead + "[0-9]*";
            this.numexpr = Pattern.compile(re);
        }
        return this.numexpr;
    }
}

