/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.taggers;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.impl.ParameterInt;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TagOccurrence;
import cz.vutbr.fit.layout.text.tag.TextTag;
import cz.vutbr.fit.layout.text.taggers.NERTagger;
import edu.stanford.nlp.util.Triple;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class PersonsTagger
extends NERTagger {
    private static final float YES = 0.8f;
    private static final float COULDBE = 0.1f;
    private static final float NO = 0.0f;
    protected Pattern couldexpr = Pattern.compile("\\p{Lu}[\\p{L}&&[^\\p{Lu}]]+\\s+\\p{Lu}[\\p{L}&&[^\\p{Lu}]]+");
    protected Pattern contexpr = Pattern.compile("[A-Z][A-Za-z]");
    private int mincnt;

    public PersonsTagger() {
        this.mincnt = 1;
    }

    public PersonsTagger(int mincnt) {
        this.mincnt = mincnt;
    }

    public String getId() {
        return "FITLayout.Tag.Person";
    }

    public String getName() {
        return "Persons";
    }

    public String getDescription() {
        return "NER-based personal name area tagger. It tags the areas that contain at least the specified number of personal names.";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(1);
        ret.add((Parameter)new ParameterInt("mincnt"));
        return ret;
    }

    public int getMincnt() {
        return this.mincnt;
    }

    public void setMincnt(int mincnt) {
        this.mincnt = mincnt;
    }

    public TextTag getTag() {
        return new TextTag("persons", this);
    }

    public float belongsTo(Area node) {
        if (node.isLeaf()) {
            String text = node.getText();
            List list = this.getClassifier().classifyToCharacterOffsets(text);
            int cnt = 0;
            for (Triple t : list) {
                if (((String)t.first()).equals("PERSON")) {
                    ++cnt;
                }
                if (cnt < this.mincnt) continue;
                return 0.8f;
            }
            if (this.checkAllowedFormat(text)) {
                return 0.1f;
            }
        }
        return 0.0f;
    }

    private boolean checkAllowedFormat(String text) {
        int cnt = 0;
        while (this.couldexpr.matcher(text).find()) {
            if (++cnt < this.mincnt) continue;
            return true;
        }
        return false;
    }

    public boolean allowsContinuation(Area node) {
        String text;
        return node.isLeaf() && this.contexpr.matcher(text = node.getText().trim()).lookingAt();
    }

    public boolean mayCoexistWith(Tag other) {
        return true;
    }

    public boolean allowsJoining() {
        return true;
    }

    public List<TagOccurrence> extract(String src) {
        ArrayList<TagOccurrence> ret = new ArrayList<TagOccurrence>();
        List list = this.getClassifier().classifyToCharacterOffsets(src);
        for (Triple t : list) {
            if (!((String)t.first()).equals("PERSON")) continue;
            ret.add(new TagOccurrence(src.substring((Integer)t.second(), (Integer)t.third()), ((Integer)t.second()).intValue(), 0.8f));
        }
        return ret;
    }
}

