/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.taggers;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TagOccurrence;
import cz.vutbr.fit.layout.text.tag.TextTag;
import cz.vutbr.fit.layout.text.taggers.BaseTagger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeTagger
extends BaseTagger {
    private static final float YES = 0.95f;
    private static final float NO = 0.0f;
    protected Pattern[] timeexpr = new Pattern[]{Pattern.compile("[0-2]?[0-9][:\\.][0-5][0-9]([ap])?m?")};

    public String getId() {
        return "FITLayout.Tag.Time";
    }

    public String getName() {
        return "Times";
    }

    public String getDescription() {
        return "Tags the areas that contain some time expressions";
    }

    public TextTag getTag() {
        return new TextTag("time", this);
    }

    public float belongsTo(Area node) {
        if (node.isLeaf()) {
            String[] words;
            String text = node.getText();
            for (String s : words = text.split("\\s+")) {
                for (Pattern p : this.timeexpr) {
                    if (!p.matcher(s).lookingAt()) continue;
                    return 0.95f;
                }
            }
        }
        return 0.0f;
    }

    public boolean allowsContinuation(Area node) {
        return false;
    }

    public boolean allowsJoining() {
        return false;
    }

    public boolean mayCoexistWith(Tag other) {
        return true;
    }

    public List<TagOccurrence> extract(String src) {
        ArrayList<TagOccurrence> ret = new ArrayList<TagOccurrence>();
        String[] words = src.toLowerCase().split("[^0-9:\\.apm]");
        int lastIndex = 0;
        for (String s : words) {
            for (Pattern p : this.timeexpr) {
                Matcher match = p.matcher(s);
                if (!match.lookingAt()) continue;
                String text = match.group();
                int pos = src.indexOf(text, lastIndex);
                ret.add(new TagOccurrence(text, pos, 0.95f));
                lastIndex = pos + 1;
            }
        }
        return ret;
    }
}

