/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.chunks;

import cz.vutbr.fit.layout.api.AreaUtils;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.text.chunks.SourceBoxList;
import java.util.List;

public class BoxText {
    private SourceBoxList boxes;
    private String text;
    private int[] offsets;
    private int[] lengths;

    public BoxText(SourceBoxList boxes) {
        this.boxes = boxes;
        this.computeOffsets();
    }

    public List<Box> getBoxes() {
        return this.boxes;
    }

    public int getBoxCount() {
        return this.boxes.size();
    }

    public String getText() {
        return this.text;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public int length() {
        return this.text.length();
    }

    public int getIndexForPosition(int pos) {
        if (pos >= 0 && pos < this.text.length()) {
            int i = 0;
            while (i + 1 < this.offsets.length && this.offsets[i + 1] <= pos) {
                ++i;
            }
            return i;
        }
        return -1;
    }

    public Box getBoxForPosition(int pos) {
        int i = this.getIndexForPosition(pos);
        return i == -1 ? null : (Box)this.boxes.get(i);
    }

    public Rectangular getSubstringBounds(int spos, int epos) {
        if (spos >= 0 && spos < this.text.length() && epos >= 0 && epos <= this.text.length() && epos > spos) {
            Rectangular r;
            int bi1 = this.getIndexForPosition(spos);
            int ofs1 = spos - this.offsets[bi1];
            int bi2 = this.getIndexForPosition(epos - 1);
            int ofs2 = epos - this.offsets[bi2];
            if (bi1 == bi2) {
                Box box = (Box)this.boxes.get(bi1);
                r = box.getSubstringBounds(ofs1, ofs2);
            } else {
                Box box1 = (Box)this.boxes.get(bi1);
                Box box2 = (Box)this.boxes.get(bi2);
                r = box1.getSubstringBounds(ofs1, box1.getOwnText().length());
                Rectangular r2 = box2.getSubstringBounds(0, ofs2);
                if (r != null && r2 != null) {
                    if (r2.getX1() >= r.getX2() && r2.getY1() < r.getY2()) {
                        r.expandToEnclose(r2);
                    } else if (this.boxes.isBlockLayout()) {
                        r.expandToEnclose(r2);
                    } else {
                        r.setX2(r.getX2() + r2.getWidth());
                    }
                }
            }
            return r;
        }
        return null;
    }

    public String toString() {
        return this.text;
    }

    private void computeOffsets() {
        StringBuilder sb = new StringBuilder();
        this.offsets = new int[this.boxes.size()];
        this.lengths = new int[this.boxes.size()];
        Box prev = null;
        int i = 0;
        for (Box box : this.boxes) {
            if (prev != null && this.boxesSeparated(prev, box)) {
                sb.append(' ');
            }
            String btext = box.getOwnText();
            this.offsets[i] = sb.length();
            this.lengths[i] = btext.length();
            sb.append(btext);
            prev = box;
            ++i;
        }
        this.text = sb.toString();
    }

    private boolean boxesSeparated(Box box1, Box box2) {
        Rectangular r2;
        Rectangular r1 = box1.getBounds();
        if (AreaUtils.isOnSameLine((Rectangular)r1, (Rectangular)(r2 = box2.getBounds()))) {
            int minSep = Math.round(Math.max(box1.getTextStyle().getFontSize(), box2.getTextStyle().getFontSize()) * 0.4f);
            int dist = box2.getX1() - box1.getX2();
            return dist >= minSep;
        }
        return true;
    }
}

