/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.taggers;

import cz.vutbr.fit.layout.api.Tagger;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.TagOccurrence;
import cz.vutbr.fit.layout.text.taggers.BaseTagger;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class CombinedTagger
extends BaseTagger {
    private LinkedHashMap<Tagger, Float> subTaggers = new LinkedHashMap();

    public LinkedHashMap<Tagger, Float> getSubTaggers() {
        return this.subTaggers;
    }

    public void addTagger(Tagger tagger, float weight) {
        this.subTaggers.put(tagger, Float.valueOf(weight));
    }

    public float belongsTo(Area node) {
        for (Map.Entry<Tagger, Float> entry : this.subTaggers.entrySet()) {
            Tagger t = entry.getKey();
            float support = t.belongsTo(node);
            if (!(support > 0.01f)) continue;
            return entry.getValue().floatValue() * support;
        }
        return 0.0f;
    }

    public List<TagOccurrence> extract(String src) {
        for (Map.Entry<Tagger, Float> entry : this.subTaggers.entrySet()) {
            Tagger t = entry.getKey();
            List occlist = t.extract(src);
            if (occlist.isEmpty()) continue;
            return occlist;
        }
        return Collections.emptyList();
    }
}

