/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.taggers;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.impl.ParameterInt;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TagOccurrence;
import cz.vutbr.fit.layout.text.taggers.NERTagger;
import edu.stanford.nlp.util.Triple;
import java.util.ArrayList;
import java.util.List;

public class LocationsTagger
extends NERTagger {
    private static final float YES = 0.8f;
    private static final float NO = 0.0f;
    private int mincnt;

    public LocationsTagger() {
        this.mincnt = 1;
    }

    public LocationsTagger(int mincnt) {
        this.mincnt = mincnt;
    }

    public String getId() {
        return "FITLayout.Tag.Location";
    }

    public String getName() {
        return "Locations";
    }

    public String getDescription() {
        return "NER-based location name area tagger. It tags the areas that contain at least the specified number of location names";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(1);
        ret.add((Parameter)new ParameterInt("mincnt"));
        return ret;
    }

    public int getMincnt() {
        return this.mincnt;
    }

    public void setMincnt(int mincnt) {
        this.mincnt = mincnt;
    }

    public float belongsTo(Area node) {
        if (node.isLeaf()) {
            String text = node.getText();
            List list = this.getClassifier().classifyToCharacterOffsets(text);
            int cnt = 0;
            for (Triple t : list) {
                if (((String)t.first()).equals("LOCATION")) {
                    ++cnt;
                }
                if (cnt < this.mincnt) continue;
                return 0.8f;
            }
        }
        return 0.0f;
    }

    public boolean allowsContinuation(Area node) {
        return false;
    }

    public boolean allowsJoining() {
        return true;
    }

    public boolean mayCoexistWith(Tag other) {
        return true;
    }

    public List<TagOccurrence> extract(String src) {
        ArrayList<TagOccurrence> ret = new ArrayList<TagOccurrence>();
        List list = this.getClassifier().classifyToCharacterOffsets(src);
        for (Triple t : list) {
            if (!((String)t.first()).equals("LOCATION")) continue;
            ret.add(new TagOccurrence(src.substring((Integer)t.second(), (Integer)t.third()), ((Integer)t.second()).intValue(), 0.8f));
        }
        return ret;
    }
}

