/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.chunks;

import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.text.chunks.PresentationHint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChunksCache {
    private Map<TagSpec, List<TextChunk>> chunks = new HashMap<TagSpec, List<TextChunk>>();
    private int reads = 0;
    private int hits = 0;

    public void put(Tag tag, List<PresentationHint> hints, List<TextChunk> chunkAreas) {
        TagSpec key = new TagSpec(tag, hints);
        this.chunks.put(key, chunkAreas);
    }

    public List<TextChunk> get(Tag tag, List<PresentationHint> hints) {
        TagSpec key = new TagSpec(tag, hints);
        List<TextChunk> ret = this.chunks.get(key);
        ++this.reads;
        if (ret != null) {
            ++this.hits;
        }
        return ret;
    }

    public int size() {
        return this.chunks.size();
    }

    public int getReads() {
        return this.reads;
    }

    public int getHits() {
        return this.hits;
    }

    public int getChunkCount() {
        int r = 0;
        for (List<TextChunk> list : this.chunks.values()) {
            r += list.size();
        }
        return r;
    }

    private static class TagSpec {
        private Tag tag;
        private List<PresentationHint> hints;

        public TagSpec(Tag tag, List<PresentationHint> hints) {
            this.tag = tag;
            this.hints = hints;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.hints == null ? 0 : this.hints.hashCode());
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TagSpec other = (TagSpec)obj;
            if (this.hints == null ? other.hints != null : !this.hints.equals(other.hints)) {
                return false;
            }
            return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
        }
    }
}

