/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.chunks;

import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TagOccurrence;
import cz.vutbr.fit.layout.text.chunks.BoxText;
import cz.vutbr.fit.layout.text.chunks.DefaultHint;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HintSeparator
extends DefaultHint {
    private List<String> separators;
    private Tag tag;
    private Pattern pattern;

    public HintSeparator(Tag tag, List<String> separators, float support) {
        super("Separator", support);
        this.tag = tag;
        this.separators = separators;
        Object ps = "";
        for (String sep : separators) {
            if (((String)ps).length() > 0) {
                ps = (String)ps + "|";
            }
            ps = (String)ps + Pattern.quote(sep);
        }
        this.pattern = Pattern.compile((String)ps, 2);
    }

    public Tag getTag() {
        return this.tag;
    }

    public List<String> getSeparators() {
        return this.separators;
    }

    @Override
    public String toString() {
        return "Separated by " + this.separators;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.separators == null ? 0 : this.separators.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HintSeparator other = (HintSeparator)obj;
        return !(this.separators == null ? other.separators != null : !this.separators.equals(other.separators));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<TagOccurrence> processOccurrences(BoxText boxText, List<TagOccurrence> occurrences) {
        void var6_9;
        List<TagOccurrence> splitOccurrences = this.findOccurrencesBySeparators(boxText.toString());
        ArrayList<String> splits = new ArrayList<String>(splitOccurrences.size());
        for (TagOccurrence tagOccurrence : splitOccurrences) {
            splits.add(tagOccurrence.getText());
        }
        ArrayList<String> occ = new ArrayList<String>(occurrences.size());
        for (TagOccurrence o : occurrences) {
            occ.add(o.getText());
        }
        boolean bl = false;
        int is = 0;
        while (var6_9 < occ.size() && is < splits.size()) {
            String cur = (String)occ.get((int)var6_9);
            if (!cur.equals(splits.get(is))) {
                if (is + 1 < splits.size() && cur.equals(splits.get(is + 1))) {
                    occurrences.add(splitOccurrences.get(is));
                    ++is;
                    continue;
                }
                ++var6_9;
                ++is;
                continue;
            }
            ++var6_9;
            ++is;
        }
        return occurrences;
    }

    private List<TagOccurrence> findOccurrencesBySeparators(String text) {
        TagOccurrence occ;
        ArrayList<TagOccurrence> ret = new ArrayList<TagOccurrence>();
        Matcher match = this.pattern.matcher(text);
        int last = 0;
        while (match.find()) {
            occ = this.findOccurenceBetweeen(text, last, match.start() - 1);
            ret.add(occ);
            last = match.end();
        }
        if (last < text.length() - 1) {
            occ = this.findOccurenceBetweeen(text, last, text.length() - 1);
            ret.add(occ);
        }
        return ret;
    }

    private TagOccurrence findOccurenceBetweeen(String text, int firstPos, int lastPos) {
        int end;
        int begin;
        for (begin = firstPos; begin < text.length() && Character.isWhitespace(text.charAt(begin)); ++begin) {
        }
        for (end = lastPos; end >= begin && Character.isWhitespace(text.charAt(end)); --end) {
        }
        return new TagOccurrence(text.substring(begin, end + 1), begin, 1.0f);
    }
}

