/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.chunks;

import cz.vutbr.fit.layout.api.Tagger;
import cz.vutbr.fit.layout.api.TaggerConfig;
import cz.vutbr.fit.layout.impl.DefaultTextChunk;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TagOccurrence;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.text.chunks.BoxText;
import cz.vutbr.fit.layout.text.chunks.ChunksCache;
import cz.vutbr.fit.layout.text.chunks.ChunksSource;
import cz.vutbr.fit.layout.text.chunks.PresentationHint;
import cz.vutbr.fit.layout.text.chunks.SourceBoxList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresentationBasedChunksSource
extends ChunksSource {
    private static Logger log = LoggerFactory.getLogger(PresentationBasedChunksSource.class);
    private int idcnt;
    private TaggerConfig tagConfig;
    private float minTagSupport;
    private ChunksCache cache;
    private List<TextChunk> areas;
    private Map<Tag, List<TextChunk>> tagAreas;
    private Map<Tag, List<PresentationHint>> hints;

    public PresentationBasedChunksSource(Area root, TaggerConfig tagConfig, float minTagSupport, ChunksCache cache) {
        super(root);
        this.tagConfig = tagConfig;
        this.minTagSupport = minTagSupport;
        this.cache = cache;
        this.hints = new HashMap<Tag, List<PresentationHint>>();
        this.idcnt = 1;
    }

    @Override
    public List<TextChunk> getTextChunks() {
        if (this.areas == null) {
            this.tagAreas = new HashMap<Tag, List<TextChunk>>();
            Set<Tag> supportedTags = this.findLeafTags(this.getRoot());
            if (!supportedTags.isEmpty()) {
                for (Tag t : supportedTags) {
                    List<PresentationHint> hintList = this.hints.get(t);
                    List<TextChunk> chunks = null;
                    if (this.cache != null) {
                        chunks = this.cache.get(t, hintList);
                    }
                    if (chunks == null) {
                        chunks = this.extractChunks(t, hintList);
                        if (this.cache != null) {
                            this.cache.put(t, hintList, chunks);
                        }
                    }
                    this.tagAreas.put(t, chunks);
                }
            }
            this.areas = this.disambiguateAreas(this.tagAreas);
        }
        return this.areas;
    }

    public void addHint(Tag tag, PresentationHint hint) {
        List<PresentationHint> list = this.hints.get(tag);
        if (list == null) {
            list = new ArrayList<PresentationHint>();
            this.hints.put(tag, list);
        }
        list.add(hint);
    }

    public String toString() {
        return "ChunkSource" + this.hints.toString();
    }

    private List<TextChunk> extractChunks(Tag t, List<PresentationHint> hints) {
        List<TextChunk> destChunks = new ArrayList<TextChunk>();
        ArrayList<TextChunk> destAll = new ArrayList<TextChunk>();
        HashSet<Area> processed = new HashSet<Area>();
        this.recursiveScan(this.getRoot(), t, destChunks, destAll, processed);
        if (hints != null) {
            destChunks = this.applyHints(destChunks, hints);
        }
        ArrayList<TextChunk> rects = new ArrayList<TextChunk>(destAll.size());
        rects.addAll(destAll);
        return destChunks;
    }

    private List<TextChunk> disambiguateAreas(Map<Tag, List<TextChunk>> areas) {
        ArrayList<TextChunk> all = new ArrayList<TextChunk>();
        for (List<TextChunk> sub : areas.values()) {
            all.addAll(sub);
        }
        return all;
    }

    private List<TextChunk> applyHints(List<TextChunk> areas, List<PresentationHint> hints) {
        List<TextChunk> current = areas;
        for (PresentationHint hint : hints) {
            current = hint.postprocessChunks(current);
        }
        return current;
    }

    private void recursiveScan(Area root, Tag tag, List<TextChunk> destChunks, List<TextChunk> destAll, Set<Area> processed) {
        if (root.isLeaf()) {
            if (root.hasTag(tag, this.minTagSupport) && !processed.contains(root)) {
                this.createAreasFromTag(root, tag, destChunks, destAll, processed);
            }
        } else {
            for (Area child : root.getChildren()) {
                this.recursiveScan(child, tag, destChunks, destAll, processed);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createAreasFromTag(Area a, Tag t, List<TextChunk> destChunks, List<TextChunk> destAll, Set<Area> processed) {
        ArrayList<TextChunk> chunks = new ArrayList<TextChunk>();
        ArrayList<TextChunk> all = new ArrayList<TextChunk>();
        Tagger tg = this.tagConfig.getTaggerForTag(t);
        if (tg != null) {
            SourceBoxList boxes = this.extractBoxes(a, t, processed);
            BoxText boxText = new BoxText(boxes);
            List<TagOccurrence> occurrences = tg.extract(boxText.getText());
            if (this.hints.containsKey(t)) {
                for (PresentationHint presentationHint : this.hints.get(t)) {
                    occurrences = presentationHint.processOccurrences(boxText, occurrences);
                }
            }
            int last = 0;
            for (TagOccurrence occ : occurrences) {
                if (occ.getLength() > 0) {
                    int pos = occ.getPosition();
                    if (pos > last) {
                        String substr = boxText.getText().substring(last, pos);
                        TagOccurrence between = new TagOccurrence(substr, last, 1.0f);
                        TextChunk sepArea = this.createSubstringArea(a, t, false, boxText, between);
                        all.add(sepArea);
                    }
                    TextChunk newArea = this.createSubstringArea(a, t, true, boxText, occ);
                    chunks.add(newArea);
                    all.add(newArea);
                    last = pos + occ.getLength();
                    continue;
                }
                log.error("Zero length occurence: {}, tag {}, area {}", new Object[]{occ, t, a});
            }
            if (boxText.length() > last) {
                String string = boxText.getText().substring(last);
                TagOccurrence between = new TagOccurrence(string, last, 1.0f);
                TextChunk sepArea = this.createSubstringArea(a, t, false, boxText, between);
                all.add(sepArea);
            }
            ArrayList<TextChunk> arrayList = chunks;
            if (this.hints.containsKey(t)) {
                for (PresentationHint hint : this.hints.get(t)) {
                    void var13_19;
                    List<TextChunk> list = hint.processChunks(a, (List<TextChunk>)var13_19);
                }
            }
            destChunks.addAll(chunks);
            destAll.addAll(all);
        }
    }

    private TextChunk createSubstringArea(Area a, Tag tag, boolean present, BoxText boxText, TagOccurrence occ) {
        Rectangular r = boxText.getSubstringBounds(occ.getPosition(), occ.getPosition() + occ.getLength());
        DefaultTextChunk newChunk = new DefaultTextChunk(r, a, boxText.getBoxForPosition(occ.getPosition()));
        newChunk.setId(this.idcnt++);
        newChunk.setText(occ.getText());
        if (present) {
            newChunk.setName("<chunk:" + tag.getName() + "> " + occ);
            newChunk.addTag(tag, a.getTagSupport(tag));
        } else {
            newChunk.setName("<chunk:!" + tag.getName() + "> " + occ);
        }
        return newChunk;
    }

    private SourceBoxList extractBoxes(Area src, Tag t, Set<Area> processed) {
        processed.add(src);
        SourceBoxList current = new SourceBoxList(src.getBoxes(), true);
        if (this.hints.containsKey(t)) {
            for (PresentationHint hint : this.hints.get(t)) {
                current = hint.extractBoxes(src, current, processed);
            }
        }
        return current;
    }

    private Set<Tag> findLeafTags(Area root) {
        HashSet<Tag> ret = new HashSet<Tag>();
        this.recursiveCollectTags(root, ret);
        return ret;
    }

    private void recursiveCollectTags(Area root, Set<Tag> dest) {
        if (root.isLeaf()) {
            Set all = root.getSupportedTags(this.minTagSupport);
            for (Tag t : all) {
                dest.add(t);
            }
        } else {
            for (Area child : root.getChildren()) {
                this.recursiveCollectTags(child, dest);
            }
        }
    }
}

