/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.chunks;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.api.TaggerConfig;
import cz.vutbr.fit.layout.impl.BaseArtifactService;
import cz.vutbr.fit.layout.impl.DefaultChunkSet;
import cz.vutbr.fit.layout.impl.ParameterBoolean;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.ChunkSet;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.text.chunks.AreaTextChunksSource;
import cz.vutbr.fit.layout.text.chunks.ChunksSource;
import cz.vutbr.fit.layout.text.chunks.TaggedChunksSource;
import cz.vutbr.fit.layout.text.tag.FixedTaggerConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;

public class TextChunksProvider
extends BaseArtifactService {
    private TaggerConfig tagConfig;
    private boolean useWholeAreaText;

    public TextChunksProvider() {
        this.tagConfig = new FixedTaggerConfig();
        this.useWholeAreaText = false;
    }

    public TextChunksProvider(TaggerConfig tagConfig) {
        this.tagConfig = tagConfig;
        this.useWholeAreaText = false;
    }

    public TaggerConfig getTaggerConfig() {
        return this.tagConfig;
    }

    public void setTaggerConfig(TaggerConfig tagConfig) {
        this.tagConfig = tagConfig;
    }

    public boolean getUseWholeAreaText() {
        return this.useWholeAreaText;
    }

    public void setUseWholeAreaText(boolean useAreaText) {
        this.useWholeAreaText = useAreaText;
    }

    public String getId() {
        return "FitLayout.TextChunks";
    }

    public String getName() {
        return "Tagged text chunks extractor";
    }

    public String getDescription() {
        return "Extracts tagged text chunks from an area tree.";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(1);
        ret.add((Parameter)new ParameterBoolean("useWholeAreaText"));
        return ret;
    }

    public IRI getConsumes() {
        return SEGM.AreaTree;
    }

    public IRI getProduces() {
        return SEGM.ChunkSet;
    }

    public Artifact process(Artifact input) throws ServiceException {
        if (input != null && input instanceof AreaTree) {
            return this.extractChunks((AreaTree)input);
        }
        throw new ServiceException("Source artifact not specified or not an area tree");
    }

    private ChunkSet extractChunks(AreaTree atree) {
        ChunksSource csrc = this.useWholeAreaText ? new AreaTextChunksSource(atree.getRoot(), this.tagConfig) : new TaggedChunksSource(this.tagConfig, atree.getRoot(), 0.1f);
        List<TextChunk> chunks = csrc.getTextChunks();
        DefaultChunkSet ret = new DefaultChunkSet(atree.getIri(), new HashSet<TextChunk>(chunks));
        ret.setPageIri(atree.getPageIri());
        ret.setLabel(this.getId());
        ret.setCreator(this.getId());
        ret.setCreatorParams(this.getParamString());
        return ret;
    }
}

