/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.tag;

import cz.vutbr.fit.layout.api.Tagger;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Tag;
import java.util.Collection;
import java.util.Map;

public class TreeTagger {
    private static final float MIN_SUPPORT = 0.01f;
    protected Area root;
    protected Map<Tag, Tagger> taggers;

    public TreeTagger(Area root, Map<Tag, Tagger> taggers) {
        this.root = root;
        this.taggers = taggers;
    }

    public Collection<Tag> getAllTags() {
        return this.taggers.keySet();
    }

    public void tagTree() {
        this.tagSubtree(this.root);
    }

    public void tagSubtree(Area root) {
        this.tagSingleNode(root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.tagSubtree((Area)root.getChildAt(i));
        }
    }

    public void tagSingleNode(Area area) {
        for (Tag tag : this.taggers.keySet()) {
            Tagger t = this.taggers.get(tag);
            float support = t.belongsTo(area);
            if (!(support > 0.01f)) continue;
            area.addTag(tag, support);
        }
    }
}

