/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.taggers;

import cz.vutbr.fit.layout.text.tag.TreeTagger;
import cz.vutbr.fit.layout.text.taggers.BaseTagger;
import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NERTagger
extends BaseTagger {
    private static Logger log = LoggerFactory.getLogger(NERTagger.class);
    private static final String CLASSIFIER_PATH = "/english.all.3class.distsim.crf.ser.gz";
    private static AbstractSequenceClassifier<?> sharedClassifier;

    public AbstractSequenceClassifier<?> getClassifier() {
        return NERTagger.getSharedClassifier();
    }

    public static AbstractSequenceClassifier<?> getSharedClassifier() {
        if (sharedClassifier == null) {
            log.info("Loading resource {}", (Object)TreeTagger.class.getResource(CLASSIFIER_PATH));
            try {
                GZIPInputStream is = new GZIPInputStream(TreeTagger.class.getResourceAsStream(CLASSIFIER_PATH));
                sharedClassifier = CRFClassifier.getClassifier((InputStream)is);
            }
            catch (IOException e) {
                log.error("Load failed: {}", (Object)e.getMessage());
            }
            catch (ClassCastException e) {
                log.error("Load failed: {}", (Object)e.getMessage());
            }
            catch (ClassNotFoundException e) {
                log.error("Load failed: {}", (Object)e.getMessage());
            }
        }
        return sharedClassifier;
    }
}

