/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.op;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ScriptObject;
import cz.vutbr.fit.layout.api.Tagger;
import cz.vutbr.fit.layout.impl.BaseOperator;
import cz.vutbr.fit.layout.impl.ParameterBoolean;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.text.tag.TreeTagger;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagEntitiesOperator
extends BaseOperator
implements ScriptObject {
    private static final String PARAM_PREFIX = "tag_";
    private static Logger log = LoggerFactory.getLogger(TagEntitiesOperator.class);
    private TreeTagger tagger;
    private Map<Tag, Tagger> usedTaggers = new HashMap<Tag, Tagger>();
    private Set<String> disabledTags = new HashSet<String>();

    public String getId() {
        return "FitLayout.Tag.Entities";
    }

    public String getName() {
        return "Tag entities";
    }

    public String getDescription() {
        return "Recognizes entities in area text using different taggers and adds the corresponding tags to the areas.";
    }

    public String getCategory() {
        return "Classification";
    }

    public List<Parameter> defineParams() {
        Set<Tag> definedTags = this.usedTaggers.keySet();
        ArrayList<Parameter> ret = new ArrayList<Parameter>(definedTags.size());
        for (Tag tag : definedTags) {
            String pname = tag.getName();
            ret.add((Parameter)new ParameterBoolean(PARAM_PREFIX + pname));
        }
        return ret;
    }

    public boolean setParam(String name, Object value) {
        if (name.startsWith(PARAM_PREFIX) && value instanceof Boolean) {
            String tname = name.substring(PARAM_PREFIX.length());
            Boolean val = (Boolean)value;
            if (val.booleanValue()) {
                this.disabledTags.remove(tname);
            } else {
                this.disabledTags.add(tname);
            }
            return true;
        }
        return false;
    }

    public Object getParam(String name) {
        if (name.startsWith(PARAM_PREFIX)) {
            return !this.disabledTags.contains(name.substring(PARAM_PREFIX.length()));
        }
        return false;
    }

    public void addTagger(Tag tag, Tagger tagger) {
        this.usedTaggers.put(tag, tagger);
    }

    public void setTaggers(Map<Tag, Tagger> taggers) {
        this.usedTaggers = taggers;
    }

    public void clearTaggers() {
        this.usedTaggers.clear();
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        if (this.usedTaggers.isEmpty()) {
            log.warn("Applying TagEntitiesOperator with no taggers configured");
        }
        HashMap<Tag, Tagger> activeTaggers = new HashMap<Tag, Tagger>();
        for (Map.Entry<Tag, Tagger> entry : this.usedTaggers.entrySet()) {
            String tagName = entry.getKey().getName();
            if (this.disabledTags.contains(tagName)) continue;
            activeTaggers.put(entry.getKey(), entry.getValue());
        }
        this.tagger = new TreeTagger(root, activeTaggers);
        this.tagger.tagTree();
    }

    public String getVarName() {
        return "entities";
    }

    public void setIO(Reader in, Writer out, Writer err) {
    }
}

