/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text;

import cz.vutbr.fit.layout.api.AreaConcatenator;
import cz.vutbr.fit.layout.api.BoxConcatenator;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Rectangular;
import java.util.List;

public class TextFlowConcatenator
implements AreaConcatenator {
    private TextFlowBoxConcatenator boxConcatenator = new TextFlowBoxConcatenator();

    public BoxConcatenator getBoxConcatenator() {
        return this.boxConcatenator;
    }

    public String concat(List<Area> elems) {
        StringBuilder ret = new StringBuilder();
        Area prevArea = null;
        for (Area a : elems) {
            String areaText = a.getText((AreaConcatenator)this);
            if (prevArea != null && TextFlowConcatenator.shouldSeparate(prevArea, (ContentRect)a)) {
                ret.append(' ');
            }
            ret.append(areaText);
            prevArea = a;
        }
        return ret.toString();
    }

    private static boolean shouldSeparate(ContentRect a1, ContentRect a2) {
        Rectangular b1 = a1.getBounds();
        Rectangular b2 = a2.getBounds();
        return b2.getY1() > b1.midY() || b2.getY2() < b1.getX1();
    }

    public static class TextFlowBoxConcatenator
    implements BoxConcatenator {
        public String concat(List<Box> elems) {
            StringBuilder ret = new StringBuilder();
            Box prevBox = null;
            for (Box b : elems) {
                String areaText = b.getText((BoxConcatenator)this);
                if (prevBox != null && TextFlowConcatenator.shouldSeparate(prevBox, (ContentRect)b)) {
                    ret.append(' ');
                }
                ret.append(areaText);
                prevBox = b;
            }
            return ret.toString();
        }
    }
}

