/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.chunks;

import cz.vutbr.fit.layout.api.TagResolver;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.text.chunks.DefaultHint;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class HintForceResolved
extends DefaultHint {
    private Tag tag;
    private TagResolver dis;

    public HintForceResolved(Tag tag, TagResolver dis, float support) {
        super("Style", support);
        this.tag = tag;
        this.dis = dis;
    }

    public Tag getTag() {
        return this.tag;
    }

    public TagResolver getTagResolver() {
        return this.dis;
    }

    @Override
    public List<TextChunk> postprocessChunks(List<TextChunk> areas) {
        ArrayList<TextChunk> ret = new ArrayList<TextChunk>(areas.size());
        for (TextChunk a : areas) {
            if (!(a instanceof TextChunk)) continue;
            Set dtags = this.dis.getAreaTags(a.getSourceArea());
            if (a.hasTag(this.tag) && !dtags.contains(this.tag)) {
                a.removeTag(this.tag);
                a.setName("!" + a.getName());
                continue;
            }
            ret.add(a);
        }
        return ret;
    }

    @Override
    public String toString() {
        return "Style:" + this.dis;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dis == null ? 0 : this.dis.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HintForceResolved other = (HintForceResolved)obj;
        return !(this.dis == null ? other.dis != null : !this.dis.equals(other.dis));
    }
}

