/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.chunks;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.impl.BaseArtifactService;
import cz.vutbr.fit.layout.impl.DefaultChunkSet;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.ChunkSet;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.text.chunks.ChunksSource;
import cz.vutbr.fit.layout.text.chunks.LeafAreaChunksSource;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;

public class LeafAreaChunksProvider
extends BaseArtifactService {
    public String getId() {
        return "FitLayout.LeafTextChunks";
    }

    public String getName() {
        return "Leaf area text chunks extractor";
    }

    public String getDescription() {
        return "Extracts text chunks from all leaf areas in the tree.";
    }

    public List<Parameter> defineParams() {
        return Collections.emptyList();
    }

    public IRI getConsumes() {
        return SEGM.AreaTree;
    }

    public IRI getProduces() {
        return SEGM.ChunkSet;
    }

    public Artifact process(Artifact input) throws ServiceException {
        if (input != null && input instanceof AreaTree) {
            return this.extractChunks((AreaTree)input);
        }
        throw new ServiceException("Source artifact not specified or not an area tree");
    }

    private ChunkSet extractChunks(AreaTree atree) {
        LeafAreaChunksSource csrc = new LeafAreaChunksSource(atree.getRoot());
        List<TextChunk> chunks = ((ChunksSource)csrc).getTextChunks();
        DefaultChunkSet ret = new DefaultChunkSet(atree.getIri(), new HashSet<TextChunk>(chunks));
        ret.setPageIri(atree.getPageIri());
        ret.setLabel(this.getId());
        ret.setCreator(this.getId());
        ret.setCreatorParams(this.getParamString());
        return ret;
    }
}

