/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.text.chunks;

import cz.vutbr.fit.layout.api.Concatenators;
import cz.vutbr.fit.layout.impl.DefaultTextChunk;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.text.chunks.ChunksSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LeafAreaChunksSource
extends ChunksSource {
    private int idcnt;
    private List<TextChunk> chunks;

    public LeafAreaChunksSource(Area root) {
        super(root);
    }

    @Override
    public List<TextChunk> getTextChunks() {
        if (this.chunks == null) {
            this.chunks = new ArrayList<TextChunk>();
            this.recursiveScan(this.getRoot(), this.chunks);
        }
        return this.chunks;
    }

    private void recursiveScan(Area root, List<TextChunk> dest) {
        if (root.isLeaf()) {
            TextChunk chunk = this.createChunkFromArea(root);
            if (chunk != null) {
                dest.add(chunk);
            }
        } else {
            for (Area child : root.getChildren()) {
                this.recursiveScan(child, dest);
            }
        }
    }

    private TextChunk createChunkFromArea(Area area) {
        if (area.getBoxes().size() > 0) {
            String text = area.getText(Concatenators.getDefaultAreaConcatenator());
            if (!text.isEmpty()) {
                Box box = (Box)area.getBoxes().get(0);
                DefaultTextChunk newChunk = new DefaultTextChunk(area.getBounds(), area, box);
                newChunk.setId(this.idcnt++);
                newChunk.setText(text);
                for (Map.Entry entry : area.getTags().entrySet()) {
                    newChunk.addTag((Tag)entry.getKey(), ((Float)entry.getValue()).floatValue());
                }
                return newChunk;
            }
            return null;
        }
        return null;
    }
}

