/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.tools;

import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.api.ArtifactService;
import cz.vutbr.fit.layout.api.ServiceManager;
import cz.vutbr.fit.layout.bcs.BCSProvider;
import cz.vutbr.fit.layout.cssbox.CSSBoxTreeProvider;
import cz.vutbr.fit.layout.impl.DefaultArtifactRepository;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.puppeteer.PuppeteerTreeProvider;
import cz.vutbr.fit.layout.segm.BasicSegmProvider;
import cz.vutbr.fit.layout.tools.CliCommand;
import cz.vutbr.fit.layout.tools.cmd.Export;
import cz.vutbr.fit.layout.tools.cmd.ListArtifacts;
import cz.vutbr.fit.layout.tools.cmd.LoadArtifact;
import cz.vutbr.fit.layout.tools.cmd.Query;
import cz.vutbr.fit.layout.tools.cmd.Renderer;
import cz.vutbr.fit.layout.tools.cmd.Segmentator;
import cz.vutbr.fit.layout.tools.cmd.StoreArtifact;
import cz.vutbr.fit.layout.tools.cmd.UseRepository;
import cz.vutbr.fit.layout.vips.VipsProvider;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import picocli.CommandLine;

@CommandLine.Command(name="fitlayout", subcommands={Renderer.class, Segmentator.class, Export.class, UseRepository.class, ListArtifacts.class, LoadArtifact.class, StoreArtifact.class, Query.class}, footer={"Use COMMAND -h for getting usage information on the individual commands."})
public class Cli {
    private static final String CONFIG_FILE = "config.properties";
    private Page page;
    private AreaTree areaTree;
    private Artifact lastArtifact;
    private ServiceManager serviceManager;

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
        this.lastArtifact = page;
    }

    public AreaTree getAreaTree() {
        return this.areaTree;
    }

    public void setAreaTree(AreaTree areaTree) {
        this.areaTree = areaTree;
        this.lastArtifact = areaTree;
    }

    public Artifact getLastArtifact() {
        return this.lastArtifact;
    }

    public ServiceManager getServiceManager() {
        if (this.serviceManager == null) {
            this.serviceManager = ServiceManager.create();
            CSSBoxTreeProvider cssboxProvider = new CSSBoxTreeProvider();
            this.serviceManager.addArtifactService((ArtifactService)cssboxProvider);
            PuppeteerTreeProvider puppeteerProvider = new PuppeteerTreeProvider();
            this.serviceManager.addArtifactService((ArtifactService)puppeteerProvider);
            BasicSegmProvider segmProvider = new BasicSegmProvider();
            this.serviceManager.addArtifactService((ArtifactService)segmProvider);
            VipsProvider vipsProvider = new VipsProvider();
            this.serviceManager.addArtifactService((ArtifactService)vipsProvider);
            BCSProvider bcsProvider = new BCSProvider();
            this.serviceManager.addArtifactService((ArtifactService)bcsProvider);
            this.serviceManager.setArtifactRepository((ArtifactRepository)new DefaultArtifactRepository());
        }
        return this.serviceManager;
    }

    private static List<List<String>> splitArgsByCommands(String[] args, Set<String> cnames) {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        ArrayList<String> current = new ArrayList<String>();
        ret.add(current);
        for (int i = 0; i < args.length; ++i) {
            if (cnames.contains(args[i]) && !current.isEmpty()) {
                current = new ArrayList();
                ret.add(current);
            }
            current.add(args[i]);
        }
        return ret;
    }

    private static void loadConfigFile() {
        try (FileInputStream input = new FileInputStream(CONFIG_FILE);){
            Properties p = new Properties();
            p.load(input);
            for (String name : p.stringPropertyNames()) {
                String value = p.getProperty(name);
                System.setProperty(name, value);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        Cli cli = new Cli();
        CommandLine cmd = new CommandLine((Object)cli);
        cmd.setUsageHelpWidth(90);
        cmd.setUsageHelpLongOptionsMaxWidth(40);
        for (CommandLine sub : cmd.getSubcommands().values()) {
            ((CliCommand)sub.getCommandSpec().userObject()).setCli(cli);
        }
        Set<String> cnames = cmd.getSubcommands().keySet();
        List<List<String>> subcommands = Cli.splitArgsByCommands(args, cnames);
        Cli.loadConfigFile();
        for (List<String> subcl : subcommands) {
            String[] a = subcl.toArray(new String[0]);
            int exitCode = cmd.execute(a);
            if (exitCode == 0) continue;
            System.exit(exitCode);
        }
    }
}

