/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.tools.cmd;

import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.tools.CliCommand;
import java.util.concurrent.Callable;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.repository.RepositoryException;
import picocli.CommandLine;

@CommandLine.Command(name="LOAD", sortOptions=false, abbreviateSynopsis=true, description={"Loads an artifact from the repository"}, footer={"The repository must be previously opened using the USE command"})
public class LoadArtifact
extends CliCommand
implements Callable<Integer> {
    @CommandLine.Parameters(arity="1", index="0", paramLabel="iri", description={"Artifact IRI"})
    protected String artifactIri;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Integer call() throws Exception {
        try {
            ArtifactRepository repo = this.getCli().getServiceManager().getArtifactRepository();
            if (repo == null || !(repo instanceof RDFArtifactRepository)) {
                this.errNoRepo();
                return 2;
            }
            IRI iri = repo.getIriDecoder().decodeIri(this.artifactIri);
            Artifact art = repo.getArtifact(iri);
            if (art == null) {
                System.err.println("Couldn't load artifact " + iri);
                return 1;
            }
            if (art instanceof Page) {
                System.err.println("Loaded page: " + art);
                this.getCli().setPage((Page)art);
                return 0;
            }
            if (art instanceof AreaTree) {
                System.err.println("Loaded area tree: " + art);
                this.getCli().setAreaTree((AreaTree)art);
                return 0;
            }
            System.err.println("Unknwon artifact type");
            return 1;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (RepositoryException e) {
            System.err.println("Error: " + e.getMessage());
        }
        return 1;
    }
}

