/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.tools.cmd;

import cz.vutbr.fit.layout.api.ArtifactService;
import cz.vutbr.fit.layout.api.ParametrizedOperation;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.api.ServiceManager;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.tools.CliCommand;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="RENDER", sortOptions=false, abbreviateSynopsis=true, description={"Renders a page"})
public class Renderer
extends CliCommand
implements Callable<Integer> {
    @CommandLine.Option(order=100, names={"-h", "--help"}, usageHelp=true, description={"print help"})
    protected boolean help;
    @CommandLine.Option(order=1, names={"-W", "--width"}, paramLabel="width", description={"Browser window width in pixels (${DEFAULT-VALUE})"})
    protected int width = 1200;
    @CommandLine.Option(order=2, names={"-H", "--height"}, paramLabel="height", description={"Browser window height in pixels (${DEFAULT-VALUE})"})
    protected int height = 800;
    @CommandLine.Option(order=3, names={"-b", "--backend"}, paramLabel="backend_name", description={"The backend to use: ${COMPLETION-CANDIDATES} (${DEFAULT-VALUE})"})
    protected Backend backend = Backend.cssbox;
    @CommandLine.Option(order=4, names={"-O", "--options"}, paramLabel="KEY=VALUE", split="\\,", splitSynopsisLabel=",", description={"Additional rendering backend options"})
    protected Map<String, String> ropts;
    @CommandLine.Parameters(arity="1", index="0", description={"Input page URL"})
    protected String url;

    @Override
    public Integer call() throws Exception {
        try {
            Page page = this.render(this.url, this.backend, this.width, this.height, this.ropts);
            this.getCli().setPage(page);
            System.err.println("  Created: " + page);
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
        }
        catch (ServiceException e) {
            System.err.println("Rendering failed: " + e.getMessage());
        }
        return 1;
    }

    public Page render(String url, Backend backend, int width, int height, Map<String, String> params) {
        String serviceId = "";
        switch (backend) {
            case cssbox: {
                serviceId = "FitLayout.CSSBox";
                break;
            }
            case puppeteer: {
                serviceId = "FitLayout.Puppeteer";
            }
        }
        ParametrizedOperation op = this.getCli().getServiceManager().findParmetrizedService(serviceId);
        System.err.println("Rendering: " + op);
        if (op != null) {
            HashMap<String, Object> sparams = new HashMap<String, Object>();
            sparams.put("url", url);
            sparams.put("width", width);
            sparams.put("height", height);
            if (params != null) {
                sparams.putAll(params);
            }
            ServiceManager.setServiceParams((ParametrizedOperation)op, sparams);
            System.err.println("  Params: " + op.getParamString());
            Artifact page = ((ArtifactService)op).process(null);
            return (Page)page;
        }
        return null;
    }

    public static enum Backend {
        cssbox,
        puppeteer;

    }
}

