/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.tools;

import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.api.ServiceManager;
import cz.vutbr.fit.layout.impl.DefaultArtifactRepository;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.tools.CliCommand;
import cz.vutbr.fit.layout.tools.FLConfig;
import cz.vutbr.fit.layout.tools.cmd.Batch;
import cz.vutbr.fit.layout.tools.cmd.Dump;
import cz.vutbr.fit.layout.tools.cmd.Export;
import cz.vutbr.fit.layout.tools.cmd.Import;
import cz.vutbr.fit.layout.tools.cmd.Invoke;
import cz.vutbr.fit.layout.tools.cmd.ListArtifacts;
import cz.vutbr.fit.layout.tools.cmd.LoadArtifact;
import cz.vutbr.fit.layout.tools.cmd.Query;
import cz.vutbr.fit.layout.tools.cmd.Renderer;
import cz.vutbr.fit.layout.tools.cmd.Segmentator;
import cz.vutbr.fit.layout.tools.cmd.StoreArtifact;
import cz.vutbr.fit.layout.tools.cmd.UseRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import picocli.CommandLine;

@CommandLine.Command(name="fitlayout", subcommands={Renderer.class, Segmentator.class, Invoke.class, Export.class, UseRepository.class, ListArtifacts.class, LoadArtifact.class, StoreArtifact.class, Query.class, Batch.class, Import.class, Dump.class}, footer={"Use COMMAND -h for getting usage information on the individual commands."})
public class Cli {
    private static final String CONFIG_FILE = "config.properties";
    private static final String CONFIG_FILE_TEST = "config.test.properties";
    private ArtifactRepository artifactRepository = new DefaultArtifactRepository();
    private Page page;
    private AreaTree areaTree;
    private Artifact lastArtifact;

    public ArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    public void setArtifactRepository(ArtifactRepository artifactRepository) {
        this.artifactRepository = artifactRepository;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
        this.lastArtifact = page;
    }

    public AreaTree getAreaTree() {
        return this.areaTree;
    }

    public void setAreaTree(AreaTree areaTree) {
        this.areaTree = areaTree;
        this.lastArtifact = areaTree;
    }

    public Artifact getLastArtifact() {
        return this.lastArtifact;
    }

    public void setLastArtifact(Artifact art) {
        if (art instanceof Page) {
            this.setPage((Page)art);
        } else if (art instanceof AreaTree) {
            this.setAreaTree((AreaTree)art);
        } else {
            this.lastArtifact = art;
        }
    }

    public ServiceManager getServiceManager() {
        return FLConfig.createServiceManager(this.artifactRepository);
    }

    public int execCommandLine(String[] args) {
        CommandLine cmd = new CommandLine((Object)this);
        cmd.setUsageHelpWidth(90);
        cmd.setUsageHelpLongOptionsMaxWidth(40);
        for (CommandLine sub : cmd.getSubcommands().values()) {
            ((CliCommand)sub.getCommandSpec().userObject()).setCli(this);
        }
        Set<String> cnames = cmd.getSubcommands().keySet();
        List<List<String>> subcommands = Cli.splitArgsByCommands(args, cnames);
        for (List<String> subcl : subcommands) {
            String[] a = subcl.toArray(new String[0]);
            int exitCode = cmd.execute(a);
            if (exitCode == 0) continue;
            return exitCode;
        }
        return 0;
    }

    private static List<List<String>> splitArgsByCommands(String[] args, Set<String> cnames) {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        ArrayList<String> current = new ArrayList<String>();
        ret.add(current);
        for (int i = 0; i < args.length; ++i) {
            if (cnames.contains(args[i]) && !current.isEmpty()) {
                current = new ArrayList();
                ret.add(current);
            }
            current.add(args[i]);
        }
        return ret;
    }

    private static void loadConfigFile() {
        File f = new File(CONFIG_FILE_TEST);
        if (!f.isFile()) {
            f = new File(CONFIG_FILE);
        }
        if (f.isFile()) {
            try (FileInputStream input = new FileInputStream(f);){
                Properties p = new Properties();
                p.load(input);
                for (String name : p.stringPropertyNames()) {
                    String value = p.getProperty(name);
                    System.setProperty(name, value);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        Cli.loadConfigFile();
        Cli cli = new Cli();
        int exitCode = cli.execCommandLine(args);
        System.exit(exitCode);
    }
}

