/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.tools;

import cz.vutbr.fit.layout.api.AreaTreeOperator;
import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.api.ArtifactService;
import cz.vutbr.fit.layout.api.ServiceManager;
import cz.vutbr.fit.layout.api.TaggerConfig;
import cz.vutbr.fit.layout.bcs.BCSProvider;
import cz.vutbr.fit.layout.cssbox.CSSBoxTreeProvider;
import cz.vutbr.fit.layout.patterns.AreaConnectionProvider;
import cz.vutbr.fit.layout.patterns.TextChunkConnectionProvider;
import cz.vutbr.fit.layout.provider.OperatorWrapperProvider;
import cz.vutbr.fit.layout.provider.VisualBoxTreeProvider;
import cz.vutbr.fit.layout.puppeteer.PuppeteerTreeProvider;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.RDFTaggerConfig;
import cz.vutbr.fit.layout.segm.BasicSegmProvider;
import cz.vutbr.fit.layout.segm.op.CollapseAreasOperator;
import cz.vutbr.fit.layout.segm.op.FindLineOperator;
import cz.vutbr.fit.layout.segm.op.FlattenTreeOperator;
import cz.vutbr.fit.layout.segm.op.GroupByDOMOperator;
import cz.vutbr.fit.layout.segm.op.HomogeneousLeafOperator;
import cz.vutbr.fit.layout.segm.op.MultiLineOperator;
import cz.vutbr.fit.layout.segm.op.SortByLinesOperator;
import cz.vutbr.fit.layout.segm.op.SortByPositionOperator;
import cz.vutbr.fit.layout.segm.op.SuperAreaOperator;
import cz.vutbr.fit.layout.text.chunks.TextChunksProvider;
import cz.vutbr.fit.layout.text.op.TagEntitiesOperator;
import cz.vutbr.fit.layout.vips.VipsProvider;

public class FLConfig {
    public static ServiceManager createServiceManager(ArtifactRepository repo) {
        ServiceManager sm = ServiceManager.create();
        sm.addArtifactService((ArtifactService)new CSSBoxTreeProvider());
        sm.addArtifactService((ArtifactService)new PuppeteerTreeProvider());
        sm.addArtifactService((ArtifactService)new VisualBoxTreeProvider());
        sm.addArtifactService((ArtifactService)new BasicSegmProvider());
        sm.addArtifactService((ArtifactService)new VipsProvider());
        sm.addArtifactService((ArtifactService)new BCSProvider());
        FLConfig.addAreaTreeOperator(sm, (AreaTreeOperator)new CollapseAreasOperator());
        FLConfig.addAreaTreeOperator(sm, (AreaTreeOperator)new FindLineOperator());
        FLConfig.addAreaTreeOperator(sm, (AreaTreeOperator)new FlattenTreeOperator());
        FLConfig.addAreaTreeOperator(sm, (AreaTreeOperator)new MultiLineOperator());
        FLConfig.addAreaTreeOperator(sm, (AreaTreeOperator)new SortByPositionOperator());
        FLConfig.addAreaTreeOperator(sm, (AreaTreeOperator)new SortByLinesOperator());
        FLConfig.addAreaTreeOperator(sm, (AreaTreeOperator)new SuperAreaOperator());
        FLConfig.addAreaTreeOperator(sm, (AreaTreeOperator)new GroupByDOMOperator());
        FLConfig.addAreaTreeOperator(sm, (AreaTreeOperator)new HomogeneousLeafOperator());
        if (repo != null && repo instanceof RDFArtifactRepository) {
            RDFTaggerConfig tc = new RDFTaggerConfig((RDFArtifactRepository)repo);
            sm.addArtifactService((ArtifactService)new TextChunksProvider((TaggerConfig)tc));
            TagEntitiesOperator tagOp = new TagEntitiesOperator();
            tagOp.setTaggers(tc.getTaggers());
            FLConfig.addAreaTreeOperator(sm, (AreaTreeOperator)tagOp);
        }
        sm.addArtifactService((ArtifactService)new AreaConnectionProvider());
        sm.addArtifactService((ArtifactService)new TextChunkConnectionProvider());
        if (repo != null) {
            sm.setArtifactRepository(repo);
        }
        return sm;
    }

    private static void addAreaTreeOperator(ServiceManager sm, AreaTreeOperator op) {
        sm.addAreaTreeOperator(op);
        sm.addArtifactService((ArtifactService)new OperatorWrapperProvider(op));
    }
}

