/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.tools.cmd;

import cz.vutbr.fit.layout.tools.CliCommand;
import cz.vutbr.fit.layout.tools.util.ArgumentTokenizer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import picocli.CommandLine;

@CommandLine.Command(name="BATCH", sortOptions=false, abbreviateSynopsis=true, description={"Executes commands specified in an external file"})
public class Batch
extends CliCommand
implements Callable<Integer> {
    @CommandLine.Option(order=100, names={"-h", "--help"}, usageHelp=true, description={"print help"})
    protected boolean help;
    @CommandLine.Option(order=1, names={"-i", "--data"}, description={"Input data file to iterate on"})
    protected String inFile;
    @CommandLine.Option(order=2, names={"-d", "--delemiter"}, description={"Data field delimiter in the input data file (default \\\t)"})
    protected String delim = "\\t";
    @CommandLine.Option(order=3, names={"-p", "--threads"}, description={"Number of threads to use for iteration (default 1)"})
    protected int threads = 1;
    @CommandLine.Option(order=3, names={"-t", "--timeout"}, description={"Thread timeout in seconds (default 60 seconds)"})
    protected int timeout = 60;
    @CommandLine.Parameters(arity="1", index="0", paramLabel="batch_file", description={"A text file containing commands to execute"})
    protected String batchFile;
    int tasksToDo;
    int tasksDone;

    @Override
    public Integer call() throws Exception {
        try {
            String cmdString = Files.readString(Path.of(this.batchFile, new String[0]));
            if (this.inFile == null) {
                return this.execCommandLine(cmdString, null);
            }
            return this.iterateDataFile(cmdString);
        }
        catch (IOException e) {
            return 1;
        }
    }

    private int execCommandLine(String cmdString, String dataLine) {
        if (dataLine != null) {
            String[] fields = dataLine.split(this.delim);
            for (int i = 0; i < fields.length; ++i) {
                cmdString = cmdString.replaceAll("\\$" + (i + 1), fields[i]);
            }
            cmdString = cmdString.replaceAll("\\$0", dataLine);
        }
        List<String> cmdList = ArgumentTokenizer.tokenize(cmdString);
        String[] args = cmdList.toArray(new String[0]);
        return this.getCli().execCommandLine(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int iterateDataFile(String cmdString) throws IOException {
        List<BatchTask> tasks = this.createTasks(this.inFile, cmdString);
        this.tasksToDo = tasks.size();
        this.tasksDone = 0;
        ExecutorService exec = Executors.newFixedThreadPool(this.threads);
        try {
            List results = exec.invokeAll(tasks);
            int index = 0;
            for (Future ft : results) {
                try {
                    ft.get(this.timeout, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    ft.cancel(true);
                    this.taskFinished(tasks.get(index), 2);
                }
                catch (ExecutionException e) {
                    ft.cancel(true);
                    this.taskFinished(tasks.get(index), 3);
                }
                catch (TimeoutException e) {
                    ft.cancel(true);
                    this.taskFinished(tasks.get(index), 2);
                }
                ++index;
            }
            int n = 0;
            return n;
        }
        catch (InterruptedException e) {
            System.err.println("Task execution interrupted: " + e.getMessage());
            int n = 1;
            return n;
        }
        finally {
            exec.shutdown();
        }
    }

    private List<BatchTask> createTasks(String listFile, String cmdString) throws IOException {
        Path filePath = Path.of(listFile, new String[0]);
        List<String> dataLines = Files.readAllLines(filePath);
        LinkedList<BatchTask> tasks = new LinkedList<BatchTask>();
        long index = 0L;
        for (String dataLine : dataLines) {
            tasks.add(new BatchTask(this, index++, cmdString, dataLine));
        }
        return tasks;
    }

    public synchronized void taskFinished(BatchTask task, int status) {
        ++this.tasksDone;
        String msg = "";
        switch (status) {
            case 0: {
                msg = "Done";
                break;
            }
            case 1: {
                msg = "ERROR";
                break;
            }
            case 2: {
                msg = "TIMEOUT";
                break;
            }
            default: {
                msg = "ERROR";
            }
        }
        System.err.print(msg + " ");
        System.err.println("(" + task.getIndex() + ") " + task.getDataLine());
        System.err.println(this.tasksDone + " / " + this.tasksToDo + " finished");
    }

    private static class BatchTask
    implements Callable<Integer> {
        private long index;
        private Batch parent;
        private String cmdString;
        private String dataLine;

        public BatchTask(Batch parent, long index, String cmdString, String dataLine) {
            this.index = index;
            this.parent = parent;
            this.cmdString = cmdString;
            this.dataLine = dataLine;
        }

        public long getIndex() {
            return this.index;
        }

        public String getDataLine() {
            return this.dataLine;
        }

        @Override
        public Integer call() throws Exception {
            int ret = this.parent.execCommandLine(this.cmdString, this.dataLine);
            this.parent.taskFinished(this, ret);
            return ret;
        }
    }
}

