/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.tools.cmd;

import cz.vutbr.fit.layout.api.ArtifactService;
import cz.vutbr.fit.layout.api.ParametrizedOperation;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.api.ServiceManager;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.tools.CliCommand;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="INVOKE", sortOptions=false, abbreviateSynopsis=true, description={"Invokes an artifact service on the last artifact"})
public class Invoke
extends CliCommand
implements Callable<Integer> {
    @CommandLine.Option(order=100, names={"-h", "--help"}, usageHelp=true, description={"print help"})
    protected boolean help;
    @CommandLine.Option(order=1, names={"-s", "--service"}, description={"ID of the service to invoke"}, required=true)
    protected String serviceId;
    @CommandLine.Option(order=2, names={"-O", "--options"}, paramLabel="KEY=VALUE", split="\\,", splitSynopsisLabel=",", description={"Segmentation method options"})
    protected Map<String, String> sopts;

    @Override
    public Integer call() throws Exception {
        try {
            Artifact srcArt = this.getCli().getLastArtifact();
            if (srcArt == null) {
                this.errNoArtifact("INVOKE");
                return 1;
            }
            Artifact result = this.invokeService(srcArt, this.serviceId, this.sopts);
            this.getCli().setLastArtifact(result);
            System.err.println("  Created: " + result);
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
        }
        catch (ServiceException e) {
            System.err.println("Rendering failed: " + e.getMessage());
        }
        return 1;
    }

    public Artifact invokeService(Artifact srcArt, String serviceId, Map<String, String> sopts) {
        ParametrizedOperation op = this.getCli().getServiceManager().findParmetrizedService(serviceId);
        System.err.println("Invoke: " + op);
        if (op != null) {
            if (sopts != null) {
                HashMap<String, String> sparams = new HashMap<String, String>(sopts);
                ServiceManager.setServiceParams((ParametrizedOperation)op, sparams);
            }
            System.err.println("  Params: " + op.getParamString());
            Artifact result = ((ArtifactService)op).process(srcArt);
            return result;
        }
        return null;
    }
}

