/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.tools.cmd;

import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.tools.CliCommand;
import java.util.concurrent.Callable;
import org.eclipse.rdf4j.repository.RepositoryException;
import picocli.CommandLine;

@CommandLine.Command(name="USE", sortOptions=false, abbreviateSynopsis=true, description={"Opens a repository for loading or storing artifacts"})
public class UseRepository
extends CliCommand
implements Callable<Integer> {
    private static final String KEY_REPOSITORY = "fitlayout.rdf.repository";
    private static final String KEY_SERVER = "fitlayout.rdf.server";
    private static final String KEY_PATH = "fitlayout.rdf.path";
    @CommandLine.Option(order=100, names={"-h", "--help"}, usageHelp=true, description={"print help"})
    protected boolean help;
    @CommandLine.Option(order=1, names={"-s", "--suffix"}, description={"Repository path suffix to be used with the local repository (to distinguish multiple local repositories)"})
    protected String pathSuffix;
    @CommandLine.Parameters(arity="1", index="0", description={"Repository type: ${COMPLETION-CANDIDATES}"})
    protected RepositoryType repositoryType;

    @Override
    public Integer call() throws Exception {
        try {
            ArtifactRepository oldRepo = this.getCli().getArtifactRepository();
            if (oldRepo != null && oldRepo instanceof RDFArtifactRepository) {
                ((RDFArtifactRepository)oldRepo).disconnect();
            }
            RDFArtifactRepository repo = this.createArtifactRepository();
            this.getCli().setArtifactRepository((ArtifactRepository)repo);
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
        }
        catch (RepositoryException e) {
            System.err.println("Error: " + e.getMessage());
        }
        return 1;
    }

    private RDFArtifactRepository createArtifactRepository() {
        Object configPath = System.getProperty(KEY_PATH);
        if (this.pathSuffix != null && configPath != null) {
            configPath = (String)configPath + "-" + this.pathSuffix;
        }
        String configServer = System.getProperty(KEY_SERVER);
        String configRepository = System.getProperty(KEY_REPOSITORY);
        RDFArtifactRepository storage = null;
        switch (this.repositoryType) {
            case memory: {
                storage = RDFArtifactRepository.createMemory(null);
                System.err.println("Using rdf4j memory storage");
                break;
            }
            case local: {
                if (configPath == null) {
                    throw new IllegalArgumentException("fitlayout.rdf.path system property is not set. Check your repository configuration.");
                }
                String path = ((String)configPath).replace("$HOME", System.getProperty("user.home"));
                storage = RDFArtifactRepository.createNative((String)path);
                System.err.println("Using rdf4j native storage in " + path);
                break;
            }
            case http: {
                if (configServer == null) {
                    throw new IllegalArgumentException("fitlayout.rdf.server system property is not set. Check your repository configuration.");
                }
                if (configRepository == null) {
                    throw new IllegalArgumentException("fitlayout.rdf.repository system property is not set. Check your repository configuration.");
                }
                storage = RDFArtifactRepository.createHTTP((String)configServer, (String)configRepository);
                System.err.println("Using rdf4j remote HTTP storage on " + configServer + " / " + configRepository);
            }
        }
        return storage;
    }

    static enum RepositoryType {
        memory,
        local,
        http;

    }
}

