/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.tools.cmd;

import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.Serialization;
import cz.vutbr.fit.layout.tools.CliCommand;
import cz.vutbr.fit.layout.tools.cmd.Dump;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.util.Values;
import picocli.CommandLine;

@CommandLine.Command(name="IMPORT", sortOptions=false, abbreviateSynopsis=true, description={"Imports a RDF file to current repository"})
public class Import
extends CliCommand
implements Callable<Integer> {
    @CommandLine.Option(order=100, names={"-h", "--help"}, usageHelp=true, description={"print help"})
    protected boolean help;
    @CommandLine.Option(order=1, names={"-f", "--format"}, paramLabel="format", description={"Input file format: ${COMPLETION-CANDIDATES} (${DEFAULT-VALUE})."})
    protected Dump.Format format = Dump.Format.nquads;
    @CommandLine.Option(order=2, names={"-b", "--base"}, paramLabel="base_uri", description={"The base URI used for import"})
    protected String baseUri = null;
    @CommandLine.Option(order=3, names={"-c", "--context"}, paramLabel="context_iri", description={"The context (IRI) to import the file to"})
    protected String context = null;
    @CommandLine.Parameters(arity="1", index="0", paramLabel="rdf_file", description={"The input file to import"})
    protected String inputFile;

    @Override
    public Integer call() throws Exception {
        try {
            ArtifactRepository repo = this.getCli().getArtifactRepository();
            if (repo == null || !(repo instanceof RDFArtifactRepository)) {
                this.errNoRepo();
                return 2;
            }
            System.err.println("Importing " + this.inputFile);
            FileInputStream is = new FileInputStream(this.inputFile);
            RDFArtifactRepository rdfRepo = (RDFArtifactRepository)repo;
            String mime = Dump.getTypeForFormat(this.format);
            if (this.context == null) {
                if (this.baseUri == null) {
                    rdfRepo.getStorage().importStream((InputStream)is, Serialization.getFormatForMimeType((String)mime));
                } else {
                    rdfRepo.getStorage().importStream((InputStream)is, Serialization.getFormatForMimeType((String)mime), this.baseUri);
                }
            } else {
                IRI contextIri = Values.iri((String)this.context);
                if (this.baseUri == null) {
                    rdfRepo.getStorage().importStream((InputStream)is, Serialization.getFormatForMimeType((String)mime), contextIri);
                } else {
                    rdfRepo.getStorage().importStream((InputStream)is, Serialization.getFormatForMimeType((String)mime), contextIri, this.baseUri);
                }
            }
            return 0;
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return 1;
        }
    }
}

